// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char ConstDIPIterrcsid[] = "$Id: ConstDIPIter.c,v 1.6 93/05/27 11:28:13 thoth Exp $";

// $Log:	ConstDIPIter.c,v $
// Revision 1.6  93/05/27  11:28:13  thoth
// Copyright Notices
// 
// Revision 1.5  93/04/17  18:46:08  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.4  93/02/20  12:43:22  thoth
// There are now two sorts of BaseDIIters.
// 
// Revision 1.3  93/01/19  14:55:48  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/12  17:01:30  jnw
// Modified to go along with new value/pixel iter style
// 
// Revision 1.1  92/10/05  11:45:46  jnw
// Initial revision
// 

#include "ConstDIPIter.h"

template <class T>
IA_ConstDIPIter<T>::IA_ConstDIPIter(const IA_ConstDI<T> *img)
: IA_BaseDIPIter<T>(img), psiter(img->domain())
{
}

template <class T>
IA_ConstDIPIter<T>::IA_ConstDIPIter(const IA_ConstDIPIter<T> &iter)
: IA_BaseDIPIter<T>(iter.domain), psiter(iter.psiter)
{
}

template <class T>
int IA_ConstDIPIter<T>::next(IA_IntPoint& pixel_location, T& pixel_value)
{
    if (psiter(pixel_location)) {
	pixel_value = this->cdip()->value;
	return 1;
    }
    return 0;
}





