// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log:	ConstDI.h,v $
// Revision 1.11  93/05/27  11:19:29  thoth
// Copyright Notices
// 
// Revision 1.10  93/05/18  21:38:49  thoth
// range method returns ValueSet again.
// new value_array method gives an Array of image values.
// 
// 
// Revision 1.9  93/04/17  18:45:03  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.8  93/04/08  13:09:43  thoth
// new restriction and translation methods.
// 
// Revision 1.7  93/03/10  13:32:08  thoth
// range method no longer returns valueset due to
// difficulties with template implementation.
// 
// Revision 1.6  93/02/20  12:39:13  thoth
// operator() is too simple to be outline.
// The pointset should go first in an image constructor.
// 
// Revision 1.5  93/02/08  12:53:59  thoth
// refcounts are now handled by BaseDI.
// unused value is now unnamed.
// static dummy member belongs somewhere else.
// 
// Revision 1.4  93/01/19  14:55:46  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.3  92/11/14  09:35:29  jnw
// Substituted () and [] for val and ref
// 
// Revision 1.2  92/11/13  13:51:03  jnw
//  Updated to include all sorts of new goodies
// 
// Revision 1.1  92/10/05  11:43:34  jnw
// Initial revision
// 

#ifndef ConstDI_h_
#define ConstDI_h_

#include "BaseDI.h"

template <class T> class IA_ConstDIVIter;
template <class T> class IA_ConstDIPIter;

template <class T>
class IA_ConstDI: public IA_BaseDI<T> {
public:
    static char dummy;

    T value;
public:
    IA_ConstDI(const IA_IntPointSet& p, const T& val)
    : IA_BaseDI<T>(p), value(val) { }

    int extensivep() const { return 0; }

    T operator ()(const IA_IntPoint &) const { return value; }

    // ~IA_ConstDI() {}

    static IA_DiscreteImageType s_type() { return &dummy; }

    IA_DiscreteImageType type() const { return &dummy; }

    IA_BaseDI<T>* clone_self_extensively() const;

    IA_ValueSet<T> range() const;

    IA_Array<T> value_array() const;

    IA_BaseDI<T> * restricted_to(const IA_IntPointSet &ps) const {
	return new IA_ConstDI<T>(this->domain() & ps, this->value);
    }

    IA_BaseDI<T> * xlated_by(const IA_IntPoint &p) const {
	return new IA_ConstDI<T>(this->domain()+p, this->value);
    }

    IA_BaseDIVIter<T> *value_iterator() const;
    IA_BaseDIPIter<T> *pixel_iterator() const;

    ostream& print_this(ostream&) const;

    friend class IA_ConstDIVIter<T>;
    friend class IA_ConstDIPIter<T>;
};

#endif
