// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


static char ConstDIrcsid[] = "$Id: ConstDI.c,v 1.10 93/05/27 11:28:12 thoth Exp $";

// $Log:	ConstDI.c,v $
// Revision 1.10  93/05/27  11:28:12  thoth
// Copyright Notices
// 
// Revision 1.9  93/05/26  16:59:39  thoth
// plug memory leak.
// 
// Revision 1.8  93/05/18  21:38:48  thoth
// range method returns ValueSet again.
// new value_array method gives an Array of image values.
// 
// 
// Revision 1.7  93/04/17  18:45:01  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.6  93/03/10  13:31:59  thoth
// range method no longer returns valueset due to
// difficulties with template implementation.
// 
// Revision 1.5  93/02/20  12:38:32  thoth
// operator() is too simple to be outline.
// equality testing does not belong here.
// 
// Revision 1.4  93/02/08  11:34:32  thoth
// static dummy member belongs here.
// equal method should be correct now
// range method now faster.
// 
// Revision 1.3  93/01/19  14:55:44  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.2  92/11/14  09:35:18  jnw
// Substituted () and [] for val and ref
// 
// Revision 1.1  92/10/05  11:43:28  jnw
// Initial revision
// 

#include "VectorDI.h"
#include "ConstDI.h"
#include "ConstDIVIter.h"
#include "ConstDIPIter.h"
#include "IPSIter.h"

template <class T>
char IA_ConstDI<T>::dummy;

template <class T>
IA_BaseDI<T>* IA_ConstDI<T>::clone_self_extensively() const
{
    // VectorDI will throw if the pointset is nonextensive
    return (IA_BaseDI<T> *) new IA_VectorDI<T>(this->ps, this->value);
}

#if 1
template <class T>
IA_ValueSet<T> IA_ConstDI<T>::range() const
{
    return value;
}
#else
template <class T>
T* IA_ConstDI<T>::range(unsigned *sz) const
{
    T	*vec = new T[*sz=1];
    vec[0] = value;
    return vec;
}
#endif
template <class T>
IA_Array<T> IA_ConstDI<T>::value_array() const
{
    const int	sz=domain().card();
    T	*vec = new T[sz];
    for (int i=0; i<sz; i++)
	vec[i] = value;
    return IA_Array<T>(vec,sz,1);
}

//
// iterator support below
//

template <class T>
IA_BaseDIVIter<T> *IA_ConstDI<T>::value_iterator() const
{
    return new IA_ConstDIVIter<T>(this);
}

template <class T>
IA_BaseDIPIter<T> *IA_ConstDI<T>::pixel_iterator() const
{
    return new IA_ConstDIPIter<T>(this);
}

//
//
//

template <class T>
ostream& IA_ConstDI<T>::print_this(ostream &o) const
{
    o << "Constant Image - Value : " << this->value ;
    if (this->ps.extensivep()){
	IA_IPSIter iter(this->ps);
	IA_IntPoint p;
	o << ", Points follow\n";
	while(iter(p)) {
	    o << p << ", ";
	}
    } else {
	o << ", Comprehensive PointSet";
    }
    return o << "\n";
}
