// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char BaseDIIterrcsid[] = "$Id: BaseDIIter.c,v 1.4 93/05/27 11:27:54 thoth Exp $";

// $Log:	BaseDIIter.c,v $
// Revision 1.4  93/05/27  11:27:54  thoth
// Copyright Notices
// 
// Revision 1.3  93/04/17  18:44:59  thoth
// Iterator support is no longer based on a switch statement.  We now
// use a virtual method.  The user can now provide faster iterators.
// 
// Revision 1.2  93/01/19  14:55:35  jnw
// Modified to support IA_ naming convention
// 
// Revision 1.1  92/10/05  11:45:27  jnw
// Initial revision
// 

#include "BaseDIIter.h"
#include "BaseDI.h"

template <class T>
IA_BaseDIVIter<T>::IA_BaseDIVIter(const IA_BaseDI<T> *x)
{
    // cast away const
    domain = (IA_BaseDI<T>*)x;
    domain->incr_ref();
}

template <class T>
IA_BaseDIVIter<T>::~IA_BaseDIVIter()
{
    if (domain->decr_ref()<=0)
	    delete domain;
}

//
//
//

template <class T>
IA_BaseDIPIter<T>::IA_BaseDIPIter(const IA_BaseDI<T> *x)
{
    // cast away const
    domain = (IA_BaseDI<T>*)x;
    domain->incr_ref();
}

template <class T>
IA_BaseDIPIter<T>::~IA_BaseDIPIter()
{
    if (domain->decr_ref()<=0)
	delete domain;
}
