// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: placebos2.c,v $
// Revision 1.6  1994/01/31  16:05:16  thoth
// new pointset functions we use.
//
// Revision 1.5  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.4  1993/12/29  17:31:13  thoth
// New Bit ValueSet stuff.
//
// Revision 1.3  1993/11/17  18:42:47  thoth
// placebos for Complex images and templates.
// IPSIter is now PSIter<IntPoint>.
// make_iter declarations were driving a CFront error.
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:58:48  thoth
// Initial revision
//

#include <iostream.h>
#include <complex.h>

#include "Point.h"
#include "Bit.h"

// The place ClosurePS is included seems to affect how
// badly CFront will lose its mind.
#include "ClosurePS.h"

#include "ValueSet.h"
#include "Set.h"
#include "SetStructure.h"
#include "PSIter.h"
#include "CoreImage.h"
#include "ImageIter.h"

//
// Now we pacify the ptlink which doesn't know the meaning of -k
//



// FloatPointSet
IA_Set<IA_Point<double> >::IA_Set(const IA_Set<IA_Point<double> >&) {
    cout << "something\n";
}
IA_Set<IA_Point<double> >::IA_Set(unsigned, const IA_Point<double>*, unsigned) { }
IA_Set<IA_Point<double> >::IA_Set(const IA_ClosurePS<IA_Point<double> >&) { }
IA_Set<IA_Point<double> >::IA_Set() { }
IA_Set<IA_Point<double> >::~IA_Set() { }
IA_Set<IA_Point<double> >& IA_Set<IA_Point<double> >::operator=(const IA_Set<IA_Point<double> >&) { return *this; }
int IA_Set<IA_Point<double> >::operator==(const IA_Set<IA_Point<double> >&) const { return 0; }
IA_Set<IA_Point<double> > operator&(const IA_Set<IA_Point<double> >&,const IA_Set<IA_Point<double> >&rhs) { return rhs; }
IA_Set<IA_Point<double> > operator+(const IA_Set<IA_Point<double> >&lhs,const IA_Point<double>&) { return lhs; }
IA_Set<IA_Point<double> > intersect_with_structure(const IA_Set<IA_Point<double> >&lhs,const IA_Set<IA_Point<double> >&,IA_SetStructure*) { return lhs; }
IA_Set<IA_Point<double> > union_with_structure(const IA_Set<IA_Point<double> >&lhs,const IA_Set<IA_Point<double> >&,IA_SetStructure*) { return lhs; }

IA_Set<IA_Point<int> > IA_WhiteHole(unsigned) { return IA_Set<IA_Point<int> >(); }

// IntPointSet
IA_Set<IA_Point<int> >::IA_Set() { }
IA_Set<IA_Point<int> >::IA_Set(unsigned, const IA_Point<int>*, unsigned) { }
IA_Set<IA_Point<int> >::IA_Set(const IA_Point<int>&, const IA_Point<int>&) { }
IA_Set<IA_Point<int> >::IA_Set(const IA_ClosurePS<IA_Point<int> >&) { }
IA_Set<IA_Point<int> >::~IA_Set() { }
IA_Set<IA_Point<int> >& IA_Set<IA_Point<int> >::operator=(const IA_Set<IA_Point<int> >&) { return *this; }
IA_Set<IA_Point<int> > operator&(const IA_Set<IA_Point<int> >&,const IA_Set<IA_Point<int> >&rhs) { return rhs; }
IA_Set<IA_Point<int> > intersect_with_structure(const IA_Set<IA_Point<int> >&lhs,const IA_Set<IA_Point<int> >&,IA_SetStructure*) { return lhs; }
IA_Set<IA_Point<int> > union_with_structure(const IA_Set<IA_Point<int> >&lhs,const IA_Set<IA_Point<int> >&,IA_SetStructure*) { return lhs; }
IA_Set<IA_Point<int> > operator+(const IA_Set<IA_Point<int> >&lhs,const IA_Point<int>&) { return lhs; }

IA_Set<IA_Point<int> > operator&(const IA_Set<IA_Point<int> >&lhs,const IA_Set<IA_Point<double> >&) { return lhs; }

IA_Set<IA_Point<int> > intersect_with_dualstruct(const IA_Set<IA_Point<int> >&lhs,const IA_Set<IA_Point<int> >&,IA_SetStructure*) { return lhs; }

int IA_Set<IA_Point<int> >::boxy() const { return 0; }

IA_Set<IA_Point<int> > transpose(const IA_Set<IA_Point<int> > &arg) { return arg; }

#define ValueSetStuff(T) \
IA_ValueSet<T>::IA_ValueSet(T) { } \
IA_ValueSet<T>::IA_ValueSet(const T*,unsigned int) { } \
IA_ValueSet<T>& IA_ValueSet<T>::operator=(const IA_ValueSet<T>&) { return *this; } \
int IA_ValueSet<T>::contains(T) const { return 0; }


ValueSetStuff(complex)
ValueSetStuff(double)
ValueSetStuff(float)
ValueSetStuff(int)
ValueSetStuff(unsigned char)
ValueSetStuff(IA_Bit)



// Set Structure
IA_ss_interval IA_SetStructure::retrieve_interval(unsigned int) const { return IA_ss_interval(); }
IA_SetStructure::IA_SetStructure(void) { }
IA_SetStructure::~IA_SetStructure(void) { } 
unsigned IA_SetStructure::nintervals(void) const  { return 0; }
const IA_SetStructure IA_SetStructure::BOTH;
const IA_SetStructure IA_SetStructure::FIRST_ONLY;
const IA_SetStructure IA_SetStructure::SECOND_ONLY;

#define BasePSStuff(P) \
P IA_BasePS<P>::choice(void) const { return P(); } \
unsigned IA_BasePS<P >::index(const P&) const { return 0; } \
P IA_BasePS<P>::index(unsigned int) const { return P(); } \
P IA_BasePS<P>::inf(void) const{ return P(); } \
P IA_BasePS<P>::max(void) const{ return P(); } \
P IA_BasePS<P>::min(void) const{ return P(); } \
P IA_BasePS<P>::sup(void) const{ return P(); }

BasePSStuff(IA_IntPoint)
BasePSStuff(IA_FloatPoint)

#define ClosurePSStuff(P) \
char IA_ClosurePS<P>::type_; \
void IA_ClosurePS<P>::output(ostream&,unsigned int) const { return; }

ClosurePSStuff(IA_IntPoint)
ClosurePSStuff(IA_FloatPoint)
