//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log:	int-convolutions.desc,v $
// Revision 1.3  93/09/27  15:54:56  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
// 
// Revision 1.2  93/09/21  11:44:32  thoth
// remove cruft that belongs in double-convolutions.desc
// 
// Revision 1.1  93/09/15  13:04:31  thoth
// Initial revision
// 
// Revision 1.3  93/05/27  11:41:13  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// int linear_product int int zero=0
friend IA_IntDiscreteImage linear_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_IntDiscreteImage linear_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ) {
    return linear_product(img, templ, img.domain());
}

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
// int addmax_product int int zero=-MAXINT
friend IA_IntDiscreteImage addmax_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_IntDiscreteImage addmax_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ) {
    return addmax_product(img, templ, img.domain());
}

// int addmin_product int int  zero=MAXINT
friend IA_IntDiscreteImage addmin_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_IntDiscreteImage addmin_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ) {
    return addmin_product(img, templ, img.domain());
}

// int multmax_product int int zero=-1
friend IA_IntDiscreteImage multmax_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_IntDiscreteImage multmax_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ) {
    return multmax_product(img, templ, img.domain());
}

// int multmin_product int int zero=-1
friend IA_IntDiscreteImage multmin_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ,
		IA_Set<IA_IntPoint> dest_ps);

inline friend IA_IntDiscreteImage multmin_product(const IA_IntDiscreteImage &img,
		const IA_IntDDTemplate &templ) {
    return multmin_product(img, templ, img.domain());
}

