#!/local/bin/perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#

#
# $Log: gen-neighborhood-h.perl,v $
# Revision 1.1  1994/01/31  16:50:30  thoth
# Initial revision
#
# Revision 1.5  1994/01/07  15:24:40  thoth
# Image class is now CoreImage and named image types are
# Image<P,T>.
#
# Revision 1.4  1993/12/29  17:33:18  thoth
# New operator scheme that prevents the need for trivial Image conversions.
#
# Revision 1.3  1993/11/17  18:39:17  thoth
# template reductions are now supported.
# forward convolutions are now supported.
#
# Revision 1.2  1993/09/21  11:44:15  thoth
# the convolution description files can now have arbitrary
# white space in the operation specifications.
#
# Revision 1.1  93/09/15  13:03:41  thoth
# Initial revision
# 
# Revision 1.2  93/05/27  11:46:09  thoth
# Copyright Notices
# 
# Revision 1.1  93/03/18  11:22:28  thoth
# Initial revision
# 

while (<>) {
    next if /^\s*$/;

    if (/^#/) {
	print "//", $';
	next;
    }

    print "// $_";

    @_ = split;

    $sort = shift(@_);

    if ($sort eq "neighborhood") {
	local($rtype, $name, $itype, @blah) = @_;

	@_ = @blah;

	local($zero);

	while (@_) {
	    $_ = shift(@_);

	    if (/^zero=/) {
		$zero = $';
	    } else {
		warn "Unknown option $_. ";
	    }
	}

	while ($_=<>) {
	    chop;
	    last if $_ eq "end";

	    die "unknown neighborhood field: $_\n"
		unless (/^(init|accum|accvar|final|forw_init|forw_accumvar):\s*/);
	}

	# backward neighborhood reduction
	print "friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_CoreImage<IA_IntPoint,$itype> &img,\n",
	"\t\tconst IA_Neighborhood<IA_IntPoint,IA_IntPoint> &nbh,\n",
	"\t\tIA_Set<IA_IntPoint> dest_ps);\n";
	print "\n";

	print "inline friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_CoreImage<IA_IntPoint,$itype> &img,\n",
	"\t\tconst IA_Neighborhood<IA_IntPoint,IA_IntPoint> &nbh) {\n",
	"    return $name(img, nbh, img.domain());\n",
	"}\n";
	print "\n";

	# forward neighborhood reduction
	print "friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_Neighborhood<IA_IntPoint,IA_IntPoint> &nbh,\n",
	"\t\tconst IA_CoreImage<IA_IntPoint,$itype> &img,\n",
	"\t\tIA_Set<IA_IntPoint> dest_ps);\n";
	print "\n";

	print "inline friend ";
	print "IA_Image<IA_IntPoint,$rtype> $name(",
	"const IA_Neighborhood<IA_IntPoint,IA_IntPoint> &nbh,\n",
	"\t\tconst IA_CoreImage<IA_IntPoint,$itype> &img) {\n",
	"    return $name(nbh, img, img.domain());\n",
	"}\n";
	print "\n";
    }
}
