// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";


static char UcharDI_rcsid[] = "$Id: UcharDI.c,v 1.9 1994/01/31 15:49:53 thoth Exp $";

//
// $Log: UcharDI.c,v $
// Revision 1.9  1994/01/31  15:49:53  thoth
// read_PGM now can return the maxval.
//
// Revision 1.8  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.7  1993/12/29  17:06:11  thoth
// Workaround for woejus CFront bug.
// write_PGM functions will no longer calculate a maxval of 0.
//
// Revision 1.6  1993/11/17  18:27:13  thoth
// IPSIter is now PSIter<IntPoint>.
// restriction functions now go in the individual image implementation modules.
// PNM functions now throw errors.
// extensivep is now extensive.
//
// Revision 1.5  1993/10/20  18:34:27  thoth
// specializations for ostream methods that output the character as
// a number instead of a character.
//
// Revision 1.4  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.3  1993/09/27  15:56:38  thoth
// *** empty log message ***
//
// Revision 1.2  1993/09/24  11:36:35  jnw
// Fixed read_PGM to handle comments.
// Added display function
//
// Revision 1.1  93/09/15  12:57:04  thoth
// Initial revision
// 
// Revision 1.7  93/05/31  22:23:22  jnw
// Added instantiator for write_IAA
// 
// Revision 1.6  93/05/31  15:56:34  thoth
// write_PGM now supports maxval.
// 
// Revision 1.5  93/05/27  11:36:31  thoth
// Copyright Notices
// 
// Revision 1.4  93/05/26  17:03:15  thoth
// instantiate IAAIO
// 
// Revision 1.3  93/05/18  21:40:59  thoth
// IDM interface for Uchar DIs.
// support for min and max reduce operations.
// 
// Revision 1.2  93/04/17  18:48:15  thoth
// use IA_IntPoint instead of IntPoint
// 
// Revision 1.1  93/03/18  11:17:02  thoth
// Initial revision
// 

#include	"VectorI.h"
#include	"IntPoint.h"
#include	"PSIter.h"

// if we put this lonely bugger with its friends, the compiler issues
// syntax errors.  USL really needs to hire me.

ostream& IA_VectorI<IA_IntPoint,u_char>::print_this(ostream &o) const
{
    IA_PSIter<IA_IntPoint> iter(this->ps);
    IA_IntPoint p;
    int i;

    o << "VectorI - (point,value) pairs follow:\n";
    i = 0;
    while(iter(p)) {
	o << "(" << p << "," << (int)this->vec[i++] << ") ";
    }
    return o << "\n";
}

#include	"UcharDI.h"
#include	"ConstI.h"
#include	"ClosureI.h"
#include	"FunctionI.h"
#include	"ErrorI.h"
#include	"ImageIter.h"

#include	<math.h>
#include	<fstream.h>
#include	<iostream.h>
#include	<unistd.h>
#include	<string.h>

#include	"Bit.h"

// definitions and data for display function

#define IMAGE_DISPLAY_ENV_VAR "IMAGE_DISPLAY"
#define DEFAULT_IMAGE_DISPLAY "xv"

#define SEPARATOR_STRING " "
#define CLEANUP_STRING "; rm -f "

static char display_filename[]= "/tmp/IA_display_XXXXXX";

//
//
//

#include "restrict.h"

IA_BaseImage<IA_Point<int>,u_char> *restrict_toD(const IA_BaseImage<IA_Point<int>, u_char> *im, const IA_Set<IA_Point<int> > &ips) {
    return restrictD_toD(im, ips);
}


// ws
// whitespace predicate
int ws(char c)
{
    switch (c) {
    case ' ':
    case '\t':
    case '\n': return 1;
    default: return 0;
    }
}

// wsc
// stream convenience function to skip white space and comment lines
// beginning with #
istream& wsc(istream &i)
{
    while (ws(i.peek())){
	if (i.peek() == '\n') {
	    i.get();
	    if (i.peek() == '#') {
		while(i.peek() != '\n') i.get();
	    } else {
		break;
	    }
	} else {
	    i.get();
	}
    }
    return i;
}

IA_Image<IA_IntPoint,u_char>
IA_Image<IA_IntPoint,u_char>::read_PGM(istream &i, int *maxval_ret)
{
    int	width, height,maxval;
    if (i.get()=='P' && i.get()=='5'
	&& i>>wsc>>width>>wsc>>height>>wsc>>maxval) {
	if (maxval_ret)
	    *maxval_ret = maxval;
	const unsigned	size=width*height;
	unsigned char	*data = new unsigned char[size];
	{
	    int	ch = i.get();
	    if (ch!='\n')
		i.putback(ch);
	}
	if (!i.read(data, size)) {
	    ia_throw(IA::PNM_IO_ERROR, __FILE__, __LINE__);
	    return IA_Image<IA_IntPoint,u_char>();
	}
	return     IA_Image<IA_IntPoint,u_char>
	  (IA_IntPointSet(IA_IntPoint(0,0), IA_IntPoint(height-1,width-1)),
	   data, size, 1);
    } else {
	ia_throw(IA::PNM_IO_ERROR, __FILE__, __LINE__);
	return IA_Image<IA_IntPoint,u_char>();
    }
}

IA_Image<IA_IntPoint,u_char>
IA_Image<IA_IntPoint,u_char>::read_PGM(const char *fname, int *maxval)
{
    ifstream	in(fname);
    return read_PGM(in, maxval);
}

ostream &IA_Image<IA_IntPoint,u_char>::write_PGM(ostream &o, unsigned maxval) const
{
    IA_IntPointSet boxydomain(domain().inf(),domain().sup());
    IA_IntPoint	width(domain().sup()-domain().inf()+1);
    o<<"P5\n"<<width[1] << " " << width[0] << " " << maxval << "\n";
    IA_PSIter<IA_IntPoint>	iter(boxydomain);
    IA_IntPoint	ip;

    while (iter(ip)) {
	if (domain().contains(ip))
	    o.put((char) (*this)(ip));
	else
	    o.put((char)0);
    }
    return o;
}

ostream &IA_Image<IA_IntPoint,u_char>::write_PGM(ostream &o) const
{
    const unsigned	m = max(*this);
    return write_PGM(o,m>0?m:1);
}

void IA_Image<IA_IntPoint,u_char>::write_PGM(const char *fname, unsigned maxval) const
{
    ofstream	out(fname);
    write_PGM(out, maxval);
}

void IA_Image<IA_IntPoint,u_char>::write_PGM(const char *fname) const
{
    ofstream	out(fname);
    const unsigned	m = max(*this);
    write_PGM(out, m>0?m:1);
}

#if 1
void IA_Image<IA_IntPoint,u_char>::IDM_display(IDP::LinkID lid, const char *label)
{
    if (label==0)
	label="unlabeled";

    IA_IntPointSet	boxy(domain().inf(),domain().sup());
    IA_IntPoint	width = domain().sup()-domain().inf() +1;
    IA_Array<unsigned> dims(width.dim());
    for (unsigned i=0; i<width.dim(); i++)
	dims[i] = width[i];

    IA_Array<u_char>	vals(this->extend(IA_Image<IA_IntPoint,u_char>(boxy,(u_char)0)) .value_array());

    IDP::WriteImage(lid, label, IDP::U_BYTE, 1, dims, vals.data_start());
}
#endif


// display
//
// Forks a process to display a UcharDiscreteImage.
//
// Returns: the uid of the process      if the fork succeeded
//          -1                          if the fork failed
//
// display writes the image to a temp file in pgm format.
//
// User can set environment variable whose name is given by define constant
//        IMAGE_DISPLAY_ENV_VAR to specify what image display application
//        is to be used to display the pgm image.
//
// Default display application name is given by DEFINE constant
//        DEFAULT_IMAGE_DISPLAY
//

pid_t display(IA_Image<IA_IntPoint,u_char> img)
{
    char *display_program;
    pid_t pid;

    // always use a fresh tmp filename
    strcpy(display_filename + strlen(display_filename) - 6, "XXXXXX");

    // Get the image display program filename
    display_program = getenv(IMAGE_DISPLAY_ENV_VAR);
    if (!display_program) {
	display_program = DEFAULT_IMAGE_DISPLAY;
    }

    // Fork and exec the display program
    if ((pid=fork())==0){
	// pid is zero, so this is the child

	// Write the image to a tmp file with a unique pid
	img.write_PGM(mktemp(display_filename));

	char *buffer;
	buffer = new char [strlen(display_program) + strlen(SEPARATOR_STRING)
			   + strlen(display_filename) + strlen(CLEANUP_STRING)
			   + strlen(display_filename)];
	strcat(strcat(strcat(strcat(strcpy(buffer, display_program),
				    SEPARATOR_STRING),
			     display_filename),
		      CLEANUP_STRING),
	       display_filename);
	// should exec a csh -c
	system(buffer);
	exit(0);
    }
    return pid;
}

//
// below are included the implementations of every image-image
// and image-scalar operation we could think of for u_char images.
//

inline int max(int a, int b)
{
    return (a<b)?b:a;
}

inline int min(int a, int b)
{
    return (a<b)?a:b;
}

#include "UcharImageOps.c"

//
//
//

ostream& IA_VectorI<IA_FloatPoint,u_char>::print_this(ostream &o) const
{
    IA_PSIter<IA_FloatPoint> iter(this->ps);
    IA_FloatPoint p;
    int i;

    o << "VectorI - (point,value) pairs follow:\n";
    i = 0;
    while(iter(p)) {
	o << "(" << p << "," << (int)this->vec[i++] << ") ";
    }
    return o << "\n";
}

//

ostream& IA_ConstI<IA_IntPoint,u_char>::print_this(ostream &o) const
{
    o << "Constant Image - Value : " << (int)this->value ;
    if (this->ps.extensive()){
	IA_PSIter<IA_IntPoint> iter(this->ps);
	IA_IntPoint p;
	o << ", Points follow\n";
	while(iter(p)) {
	    o << p << ", ";
	}
    } else {
	o << ", Comprehensive PointSet";
    }
    return o << "\n";
}

ostream& IA_ConstI<IA_FloatPoint,u_char>::print_this(ostream &o) const
{
    o << "Constant Image - Value : " << (int)this->value ;
    if (this->ps.extensive()){
	IA_PSIter<IA_FloatPoint> iter(this->ps);
	IA_FloatPoint p;
	o << ", Points follow\n";
	while(iter(p)) {
	    o << p << ", ";
	}
    } else {
	o << ", Comprehensive PointSet";
    }
    return o << "\n";
}

//

ostream& IA_FunctionRefI<IA_IntPoint,u_char>::print_this(ostream& o) const
{
    o << "FunctionRefI -";
    if (this->ps.extensive()){
	IA_PSIter<IA_IntPoint> iter(this->ps);
	IA_IntPoint p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (int)(*this->func)(p) << ") ";
	}
    } else {
	o << " Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}

ostream& IA_FunctionRefI<IA_FloatPoint,u_char>::print_this(ostream& o) const
{
    o << "FunctionRefI -";
    if (this->ps.extensive()){
	IA_PSIter<IA_FloatPoint> iter(this->ps);
	IA_FloatPoint p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (int)(*this->func)(p) << ") ";
	}
    } else {
	o << " Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}


//

static IA_IntPoint	phooey;

#if 0

class blah : public IA_ClosureI<IA_IntPoint,u_char> {
  public:
    blah() 
    :IA_ClosureI<IA_IntPoint,u_char>(IA_IntPointSet()) {}
    ostream &print_this(ostream &o) const { return o;}
    u_char operator()(const IA_IntPoint &) const { return 0; }
    IA_ClosureI<IA_IntPoint,u_char>* clone_self() const { return 0; }
};
static void dummy001()
{
    IA_IntPoint		ip;
    IA_IntPointSet	ps;
    IA_Image<IA_IntPoint,u_char>	i1;
    IA_Image<IA_IntPoint,u_char>
	i2(i1),
	i3(ps,(u_char)0),
	i4(ps, (u_char*)0, 0, 1),
	i5(ps, (u_char*)0, 0),
	i6(blah()),
	i7(ps, (u_char(*)(const IA_IntPoint&))0),
	i10(IA_CoreImage<IA_IntPoint,u_char>());
    i1 = i1.restrict(i2.range());
    (IA_CoreImage<IA_IntPoint,u_char>&)i1 = 2;
    (void)i1.type();
    i1[ip] = i1(ip);
    i1 = i1.restrict(i2.domain());
    (void)i1.extend(i2);
    (void)i1.reduce((u_char (*)(const u_char&,const u_char&)) 0, 0);
    (void)i1.reduce((u_char (*)( u_char, u_char)) 0, 0);
    cout << (IA_CoreImage<IA_IntPoint,u_char>&)i1;

//    IA_Image<IA_IntPoint,u_char>::read_IAA("");
//    IA_Image<IA_IntPoint,u_char>::read_IAA("","");
//
//    i1.write_IAA("");
//    i1.write_IAA("","");

    IA_IVIter<IA_IntPoint, u_char>	iter1(i1), iter2;
    IA_IPIter<IA_IntPoint, u_char>	iter3(i2), iter4;
    iter1 = iter2;
    iter3 = iter4;

    IA_ValueSet<u_char>	vs(i1.range());
    // I shouldn\'t have to do the following two lines
    // vs.value_type_compare(0,0);
}

#endif
