// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: Neighborhood.c,v $
// Revision 1.1  1994/01/31  16:43:38  thoth
// Initial revision
//

#include	<values.h>

#include "Image.h"
#include "ImageIter.h"
#include "VectorI.h"
#include "PSIter.h"

#include "Neighborhood.h"
#include "InvariantNbh.h"

template <class P, class Q>
void IA_Neighborhood<P,Q>::set_and_reference(IA_BaseNbh<P,Q> *p)
{
  p->incr_ref();
  bnbh = p;
}

template <class P, class Q>
void IA_Neighborhood<P,Q>::disassociate()
{
  if (bnbh->decr_ref() <= 0)
    delete bnbh;
  bnbh = 0;
}


template <class P, class Q>
IA_Neighborhood<P,Q>::IA_Neighborhood(const IA_Neighborhood<P,Q> &arg)
{
    set_and_reference(arg.bnbh);
}


template <class P, class Q>
IA_Neighborhood<P,Q>::IA_Neighborhood(unsigned dim, const IA_Set<P> &ps)
{
    set_and_reference
      (new IA_InvariantNbh<P,Q>(IA_Set<Q>::WhiteHole(dim), ps));
}

template <class P, class Q>
IA_Neighborhood<P,Q>::~IA_Neighborhood()
{
  disassociate();
}

template <class P, class Q>
IA_Neighborhood<P,Q>& IA_Neighborhood<P,Q>::operator=
	(const IA_Neighborhood<P,Q> &arg)
{
  IA_BaseNbh<P,Q>	*temp = arg.bnbh;
  temp->incr_ref();

  disassociate();

  bnbh = temp;

  return *this;
}

#include "NeighborhoodOps.c"
