// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: InvariantDT.h,v $
// Revision 1.3  1993/11/17  18:24:44  thoth
// extensivep is now extensive.
// translated is now translate.
//
// Revision 1.2  1993/10/20  18:34:05  thoth
// repair the invariant () operation.
//
// Revision 1.1  1993/09/15  12:55:24  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:22:25  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:19:13  thoth
// Templates are now separate from images.
// restriction to a pointset is now a virtual method.
// 
// Revision 1.1  93/03/18  11:05:56  thoth
// Initial revision
// 

#ifndef InvariantDT_h_
#define InvariantDT_h_

#include "BaseDT.h"

template <class I>
class IA_InvariantDT: public IA_BaseDT<I> {
  private:
    static char dummy;

  public:
    I	value;
  public:
    IA_InvariantDT(const IA_IntPointSet &ps, const I &v)
    :IA_BaseDT<I>(ps), value(v) {}

    int extensive() const { return 0; }

    I operator()(const IA_IntPoint &p) const {
	return value.translate(p);
    }
    ostream &print_this(ostream &) const;

    static IA_DiscreteImageType s_type() { return &dummy; }
    IA_DiscreteImageType type() const { return &dummy; }

    IA_BaseDT<I> *restricted_to(const IA_IntPointSet &ps) const;
};

#endif
