// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


static char InvariantDT_rcsid[] = "$Id: InvariantDT.c,v 1.1 1993/09/15 12:55:08 thoth Exp $";

//
// $Log: InvariantDT.c,v $
// Revision 1.1  1993/09/15  12:55:08  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:28:26  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:17:28  thoth
// new restricted_to method.
// 
// Revision 1.1  93/03/18  11:05:31  thoth
// Initial revision
// 

#include "InvariantDT.h"

template <class I>
IA_BaseDT<I> *IA_InvariantDT<I>::restricted_to(const IA_IntPointSet &ps) const
{
    return new IA_InvariantDT<I>(ps & this->domain(), value);
}

template <class I>
ostream & IA_InvariantDT<I>::print_this(ostream &o) const
{
    o << "Translation Invariant template, value: " << value;

    this->ps.output(o);

    return o;
}

template <class I>
char IA_InvariantDT<I>::dummy;
