// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: Image.h,v $
// Revision 1.1  1994/01/31  16:43:38  thoth
// Initial revision
//

#ifndef Image_h_
#define Image_h_

#include "Set.h"

template <class P, class T> class IA_Image {
private:
    IA_Image();
    IA_Image(const IA_Image&);
    IA_Image(const IA_Set<P>&, T*, unsigned, int);
    IA_Image(const IA_Set<P>&, T);
    ~IA_Image();

    IA_Image & operator=(const IA_Image &);
#if 0				// if only we could forward declare a
				// specialization...
    T & operator[](const P&);

    IA_Set<P> domain() const;
#endif
};

#ifndef SUPPRESS_INCLUDE
#include "BitDI.h"
#include "UcharDI.h"
#include "IntDI.h"
#include "FloatDI.h"
#include "ComplexDI.h"
#include "FloatCI.h"
#else

#if 0
#include "Bit.h"
#include <complex.h>
class IA_Image<IA_IntPoint,IA_Bit>;
class IA_Image<IA_IntPoint,u_char>;
class IA_Image<IA_IntPoint,int>;
class IA_Image<IA_IntPoint,float>;
class IA_Image<IA_IntPoint,complex>;

class IA_Image<IA_FloatPoint,float>;
#endif

#endif

#endif //Image_h_
