// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FloatCI.h,v $
// Revision 1.3  1994/01/31  15:44:34  thoth
// added new constructor from float(*)(IA_FloatPoint).
// added operator=(FCI).
//
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/10/20  18:58:47  thoth
// Initial revision
//

#ifndef FloatCI_h_
#define FloatCI_h_

#include "CoreImage.h"
#include "FloatPointSet.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

class IA_Image<IA_FloatPoint,float>: public IA_CoreImage<IA_FloatPoint,float> {
  public:
//    IA_Image<IA_FloatPoint,float>() {}
    IA_Image(const IA_Image<IA_FloatPoint,float> &fci)
    :IA_CoreImage<IA_FloatPoint,float>(fci) { }
    IA_Image(const IA_CoreImage<IA_FloatPoint,float> &fci)
    :IA_CoreImage<IA_FloatPoint,float>(fci) { }
    IA_Image(IA_FloatPointSet ps, float value)
    :IA_CoreImage<IA_FloatPoint,float>(ps,(float)value) {}
    IA_Image(IA_FloatPointSet ps, float *vp, unsigned sz,
			  int giveaway=0)
    :IA_CoreImage<IA_FloatPoint,float>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_FloatPoint,float>& i)
    :IA_CoreImage<IA_FloatPoint,float>(i) { }

    IA_Image(IA_FloatPointSet ps, float (*f)(const IA_FloatPoint&))
    :IA_CoreImage<IA_FloatPoint,float>(ps,f) {}

    IA_Image(IA_FloatPointSet ps, float (*f)(IA_FloatPoint))
    :IA_CoreImage<IA_FloatPoint,float>(ps,f) {}

    virtual ~IA_Image(){ }

    IA_Image& operator =(const IA_CoreImage<IA_FloatPoint,float> &arg) {
	(IA_CoreImage<IA_FloatPoint,float>&)*this = arg;
	return *this;
    }
    
    IA_Image<IA_FloatPoint,float>& operator=(float v) {
	float	temp=v;		// workaround CFront problem
	(IA_CoreImage<IA_FloatPoint,float>&)*this = temp;
	return *this;
    }
};

#endif
