// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: DDTempl.h,v $
// Revision 1.3  1994/01/07  15:16:26  thoth
// Copy constructor and assignment were missing.  This was bad.
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:51:55  thoth
// Initial revision
//
// Revision 1.4  93/06/10  17:23:55  thoth
// Workaround for 3.0.1 bug.
// 
// Revision 1.3  93/05/27  11:19:34  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:10:36  thoth
// Templates are now separate from images.
// 
// Revision 1.1  93/03/18  11:02:37  thoth
// Initial revision
// 

#ifndef DDTempl_h_
#define DDTempl_h_

#include "BaseDT.h"

#if 0
template <class I> class IA_ClosureDT;
#else
// Lame 3.0.1
#include "ClosureDT.h"
#endif

template <class I>
class IA_DDTemplate {
  protected:
    IA_BaseDT<I>	*bdtp;

    void set_and_reference_template(IA_BaseDT<I> *);
    void disassociate_template();

  public:
    IA_DDTemplate(const IA_DDTemplate &arg);

    // Construct a translation invariant template
    IA_DDTemplate(const IA_IntPointSet &, const I &);

    IA_DDTemplate(const IA_IntPointSet &, I (*)(const IA_IntPoint &));

    IA_DDTemplate(const IA_ClosureDT<I> &);

    ~IA_DDTemplate();

    IA_DDTemplate &operator=(const IA_DDTemplate&);

    I operator()(const IA_IntPoint &p) const { return (*bdtp)(p); }

    IA_IntPointSet domain() const { return bdtp->domain(); }
    IA_DiscreteImageType type() const { return bdtp->type(); }

    //friend I gcon(const I&, const IA_DDTemplate<I>&);
};

//template <class I>
//I gcon(const I&, const IA_DDTemplate<I>&);

#endif
