// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log: ConstImageIter.h,v $
// Revision 1.2  1993/11/17  18:14:05  thoth
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  12:51:29  thoth
// Initial revision
//

#ifndef ConstImageIter_h_
#define ConstImageIter_h_

#include <stdlib.h>
#include "PSIter.h"
#include "BaseImageIter.h"
#include "ConstI.h"


template < class P,class T>
class IA_ConstIVIter: public IA_BaseIVIter<P,T> {
protected:
    // num_left stores the number of elements in the image\'s pointset
    // over which we must still iterate
    int num_left;

    // bdip points at the base image over which we're iterating.
    IA_ConstI<P,T> *cip() const { return (IA_ConstI<P,T> *)domain; }

public:

    IA_ConstIVIter(const IA_ConstI<P,T> *);
    IA_ConstIVIter(const IA_ConstIVIter&);

    ~IA_ConstIVIter() {}

    IA_BaseIVIter<P,T> * clone_self() { return new IA_ConstIVIter(*this); }
    int next(T&);

    void reset() { this->num_left= this->domain->domain().card(); }

    IA_BaseImage<P,T> *domain_() const { return this->domain; }
};


template < class P,class T>
class IA_ConstIPIter: public IA_BaseIPIter<P,T> {
protected:
    // bdip points at the base image over which we're iterating.
    IA_ConstI<P,T> *cip() const { return (IA_ConstI<P,T>*)domain; }
    
    // psiter is an iterator over bdip's PointSet.
    IA_PSIter<P> psiter;
    
public:
    
    IA_ConstIPIter(const IA_ConstI<P,T> *);
    IA_ConstIPIter(const IA_ConstIPIter&);
    
    ~IA_ConstIPIter() {}
    
    IA_BaseIPIter<P,T> * clone_self() { return new IA_ConstIPIter(*this); }
    
    int next(P&, T&);
    void reset() { psiter.reset(); }
    
    IA_BaseImage<P,T> *domain_() const { return this->domain; }
};

#endif
