// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ComplexDI.h,v $
// Revision 1.3  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  16:53:35  thoth
// removed PGM cruft.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
// 


#ifndef ComplexDI_h_
#define ComplexDI_h_
#include <complex.h>
#include "CoreImage.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE
#include "IntDI.h"		// for chi relations

class IA_Image<IA_IntPoint,complex>: public IA_CoreImage<IA_IntPoint, complex>
{
  public:
    IA_Image():IA_CoreImage<IA_IntPoint, complex>() {}

    IA_Image(const IA_CoreImage<IA_IntPoint, float> &real,
                            const IA_CoreImage<IA_IntPoint, float> &imag);


    IA_Image(const IA_Image& im)
    :IA_CoreImage<IA_IntPoint, complex>(im) {}

    IA_Image(IA_IntPointSet ps, complex value)
    :IA_CoreImage<IA_IntPoint, complex>(ps,(complex)value) {}

    IA_Image(IA_IntPointSet ps, complex *vp, unsigned sz,
			  int giveaway=0)

    :IA_CoreImage<IA_IntPoint, complex>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_IntPoint, complex> &img)
    :IA_CoreImage<IA_IntPoint, complex>(img) {}

    IA_Image(IA_IntPointSet ps, complex (*f)(const IA_IntPoint&))
    :IA_CoreImage<IA_IntPoint, complex>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_IntPoint, complex> &d)
    :IA_CoreImage<IA_IntPoint, complex>(d) {}



    virtual ~IA_Image(){ }

#include	"ComplexImageOps.h"
};

inline int operator!=(const IA_CoreImage<IA_IntPoint,complex> &lhs,
		      const IA_CoreImage<IA_IntPoint,complex> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_IntPoint,complex> &lhs,
		      complex rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(complex lhs,
		      const IA_CoreImage<IA_IntPoint,complex> &rhs) {
    return ! (rhs == lhs);
}

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_CoreImage<IA_IntPoint, complex>&);


#endif
