// Emacs: -*- C++ -*-

//
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//


//
// $Log: BitDI.h,v $
// Revision 1.4  1994/01/31  15:39:11  thoth
// read and write PBM is now available.
// attempt to have I(bit) I(T) operations failed.
//
// Revision 1.3  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  16:53:13  thoth
// Bit Discrete Image now uses separate Bit type.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
//

#ifndef BitDI_h_
#define BitDI_h_

#include "Bit.h"
#include "CoreImage.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

#include	<complex.h>	// for the complex conversion

class IA_Image<IA_IntPoint,IA_Bit>: public IA_CoreImage<IA_IntPoint, IA_Bit>
{
  public:
    IA_Image():IA_CoreImage<IA_IntPoint, IA_Bit>() {}

    IA_Image(const IA_Image& im)
    :IA_CoreImage<IA_IntPoint, IA_Bit>(im) {}

    IA_Image(IA_IntPointSet ps, int value)
    :IA_CoreImage<IA_IntPoint, IA_Bit>(ps,(IA_Bit)value) {}

    IA_Image(IA_IntPointSet ps, IA_Bit *vp, unsigned sz,
			  int giveaway=0)
    :IA_CoreImage<IA_IntPoint, IA_Bit>(ps, vp, sz, giveaway) {}

    IA_Image(IA_IntPointSet ps, const IA_Bit *vp, unsigned sz)
    :IA_CoreImage<IA_IntPoint, IA_Bit>(ps, vp, sz) {}

    IA_Image(const IA_ClosureI<IA_IntPoint,IA_Bit> &img)
    :IA_CoreImage<IA_IntPoint, IA_Bit>(img) {}

    IA_Image(IA_IntPointSet ps, IA_Bit (*f)(const IA_IntPoint&))
    :IA_CoreImage<IA_IntPoint, IA_Bit>(ps,f) {}

    IA_Image( const IA_CoreImage<IA_IntPoint, IA_Bit> &d)
    :IA_CoreImage<IA_IntPoint, IA_Bit>(d) {}

    virtual ~IA_Image(){ }

#include        "BitImageOps.h"

#if 0

//binary pointwise commutative operator* I(u_char) I(IA_Bit) I(u_char)
friend IA_Image<IA_IntPoint, u_char> operator*(const IA_CoreImage<IA_IntPoint,u_char> &,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, u_char> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,const IA_CoreImage<IA_IntPoint,u_char> & rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* u_char I(IA_Bit) I(u_char)
friend IA_Image<IA_IntPoint, u_char> operator*(u_char,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, u_char> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,u_char rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* I(int) I(IA_Bit) I(int)
friend IA_Image<IA_IntPoint, int> operator*(const IA_CoreImage<IA_IntPoint,int> &,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, int> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,const IA_CoreImage<IA_IntPoint,int> & rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* int I(IA_Bit) I(int)
friend IA_Image<IA_IntPoint, int> operator*(int,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, int> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,int rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* I(float) I(IA_Bit) I(float)
friend IA_Image<IA_IntPoint, float> operator*(const IA_CoreImage<IA_IntPoint,float> &,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, float> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,const IA_CoreImage<IA_IntPoint,float> & rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* float I(IA_Bit) I(float)
friend IA_Image<IA_IntPoint, float> operator*(float,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, float> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,float rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* I(complex) I(IA_Bit) I(complex)
friend IA_Image<IA_IntPoint, complex> operator*(const IA_CoreImage<IA_IntPoint,complex> &,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, complex> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,const IA_CoreImage<IA_IntPoint,complex> & rhs) {
    return rhs*lhs;
}

//binary pointwise commutative operator* complex I(IA_Bit) I(complex)
friend IA_Image<IA_IntPoint, complex> operator*(complex,const IA_CoreImage<IA_IntPoint,IA_Bit> &);
friend IA_Image<IA_IntPoint, complex> operator*(const IA_CoreImage<IA_IntPoint,IA_Bit> & lhs,complex rhs) {
    return rhs*lhs;
}
#endif

    static IA_Image read_PBM(istream &);
    static IA_Image read_PBM(const char *fname);

    ostream& write_PBM(ostream &) const;
    void write_PBM(const char *fname) const;
};

inline void write_PBM(const IA_CoreImage<IA_IntPoint,IA_Bit> &img,
		      const char *fname)
{
    IA_Image<IA_IntPoint,IA_Bit>(img).write_PBM(fname);
}

inline ostream & write_PBM(const IA_CoreImage<IA_IntPoint,IA_Bit> &img, ostream &o)
{
    return IA_Image<IA_IntPoint,IA_Bit>(img).write_PBM(o);
}

//
//

inline int operator!=(const IA_CoreImage<IA_IntPoint,IA_Bit> &lhs,
	       const IA_CoreImage<IA_IntPoint,IA_Bit> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_CoreImage<IA_IntPoint,IA_Bit> &lhs,
		      IA_Bit rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(IA_Bit lhs,
		      const IA_CoreImage<IA_IntPoint,IA_Bit> &rhs) {
    return ! (rhs == lhs);
}

//
//

inline IA_Image<IA_IntPoint, IA_Bit>
operator&&(const IA_CoreImage<IA_IntPoint, IA_Bit> &lhs,
	   const IA_CoreImage<IA_IntPoint, IA_Bit> &rhs) {
    return lhs & rhs;
}

inline IA_Image<IA_IntPoint, IA_Bit>
operator&&(IA_Bit lhs,
	   const IA_CoreImage<IA_IntPoint, IA_Bit> &rhs) {
    return lhs & rhs;
}

inline IA_Image<IA_IntPoint, IA_Bit>
operator&&(const IA_CoreImage<IA_IntPoint, IA_Bit> &lhs,
	   IA_Bit rhs) {
    return lhs & rhs;
}

//
//

inline IA_Image<IA_IntPoint, IA_Bit>
operator||(const IA_CoreImage<IA_IntPoint, IA_Bit> &lhs,
	   const IA_CoreImage<IA_IntPoint, IA_Bit> &rhs) {
    return lhs | rhs;
}

inline IA_Image<IA_IntPoint, IA_Bit>
operator||(IA_Bit lhs,
	   const IA_CoreImage<IA_IntPoint, IA_Bit> &rhs) {
    return lhs | rhs;
}

inline IA_Image<IA_IntPoint, IA_Bit>
operator||(const IA_CoreImage<IA_IntPoint, IA_Bit> &lhs,
	   IA_Bit rhs) {
    return lhs | rhs;
}

//
//

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_CoreImage<IA_IntPoint, IA_Bit>&);

#endif
