// Emacs: -*- C++ -*-
static char rcsid[] = "$Id: test001.c,v 1.1 1993/05/26 16:06:39 thoth Exp $";

//
// $Log: test001.c,v $
 * Revision 1.1  1993/05/26  16:06:39  thoth
 * Initial revision
 *
//

#include "IntPointSet.h"
#include "IPSIter.h"
#include "ImageDisplayProtocol.h"

int main(int argc, char **argv)
{
    char	*disp=getenv("DISPLAY");
    if (disp==0) {
	cerr << "No DISPLAY environment variable, hasta.\n";
	exit(1);
    }

    if (argc!=2) {
	cerr << "Usage:\n" << argv[0] << " fname\n";
	exit(1);
    }
    char	*fname=argv[1];

    IDP::ClientID	cid;
    cid = IDP::NewClient("iac++ test013");
    IDP::LinkID		lid;
    lid = IDP::CreateDisplay(cid, disp, IDP::READ_WRITE);

    FILE	*fp;
    fp = fopen(fname, "r");
    if (!fp) {
	perror("opening file");
	exit(1);
    }

    int	width,height, maxval;
    if (3!=fscanf(fp, "P5 %d %d %d", &width, &height, &maxval)) {
	cerr << "Error: was expecting raw PGM (P5) image in file "
	     << fname << "\n";
	exit(1);
    }
    Array<unsigned> dimensions(2);
    dimensions[0] = height;
    dimensions[1] = width;

    int	ch;
    if ((ch=getc(fp))!='\n')
	ungetc(ch, fp);

    int	size = width*height;
    unsigned char	*arr;

    arr = new unsigned char[size];

    if (!fread(arr, size, 1, fp)) {
	perror("reading");
	exit(1);
    }
    cout << "ping" << endl;
    sleep(5);
    IDP::WriteImage(lid, "me", IDP::U_BYTE, 1, dimensions, arr);

    delete[] arr;
}
