// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: imagealgebra.h,v $
// Revision 1.5  1994/02/01  13:13:49  thoth
// Bit and Complex templates weren't available before 0.9.
// Image classes have been renamed.  We will retain name compatibility
// till 1.0.
//
// Revision 1.4  1993/11/16  13:25:40  thoth
// Add new 0.9 classes.
// Add closure classes.
//

#ifndef imagealgebra_h_
#define imagealgebra_h_

#include	"ia.h"

#include	"IntPoint.h"
#include	"FloatPoint.h"

#include	"IntPointSet.h"
#include	"FloatPointSet.h"

#if IA_MAJOR_VERSION_NUMBER<1 && IA_MINOR_VERSION_NUMBER<9
#include	"UcharDiscreteImage.h"
#include	"IntDiscreteImage.h"
#include	"FloatDiscreteImage.h"
#include	"DIVIter.h"
#include	"DIPIter.h"
#include	"display.h"
#else
#include	"PSIter.h"
#include	"ClosurePS.h"

#include	"BitDI.h"
#include	"UcharDI.h"
#include	"IntDI.h"
#include	"FloatDI.h"
#include	"ComplexDI.h"
#include	"ImageIter.h"
#include	"ClosureI.h"
#include	"ClosureDT.h"
#endif

#include	"UcharDDTempl.h"
#include	"IntDDTempl.h"
#include	"FloatDDTempl.h"

#if IA_MAJOR_VERSION_NUMBER>0 || IA_MINOR_VERSION_NUMBER>8
#include	"BitDDTempl.h"
#include	"ComplexDDTempl.h"
#endif

#if IA_MAJOR_VERSION_NUMBER==0 && IA_MINOR_VERSION_NUMBER>9
typedef IA_Image<IA_IntPoint,IA_Bit>	IA_BitDiscreteImage;
typedef IA_Image<IA_IntPoint,u_char>	IA_UcharDiscreteImage;
typedef IA_Image<IA_IntPoint,int>	IA_IntDiscreteImage;
typedef IA_Image<IA_IntPoint,float>	IA_FloatDiscreteImage;
typedef IA_Image<IA_IntPoint,complex>	IA_ComplexDiscreteImage;
#endif

#if IA_MAJOR_VERSION_NUMBER<1 && IA_MINOR_VERSION_NUMBER<9
#define chi_lt	pwise_lt
#define chi_le	pwise_le
#define chi_eq	pwise_eq
#define chi_ne	pwise_ne
#define chi_ge	pwise_ge
#define chi_gt	pwise_gt

inline IA_UcharDiscreteImage linear_product
(const IA_UcharDiscreteImage &img,
 const IA_UcharDDTemplate &templ,
 IA_IntPointSet dest_ps) {
    return gcon(img, templ, dest_ps);
}

inline IA_UcharDiscreteImage addmax_product
(const IA_UcharDiscreteImage &img,
 const IA_UcharDDTemplate &templ,
 IA_IntPointSet dest_ps) {
    return addmax(img, templ, dest_ps);
}

inline IA_UcharDiscreteImage addmin_product
(const IA_UcharDiscreteImage &img,
 const IA_UcharDDTemplate &templ,
 IA_IntPointSet dest_ps) {
    return addmin(img, templ, dest_ps);
}
#endif

#endif
