// This may look like C code, emacs, but it is really -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

#ifndef ia_h_
#define ia_h_

//
// $Log: ia.h,v $
// Revision 1.29  1994/02/01  13:12:59  thoth
// Ready for release 0.10
//
// Revision 1.28  1994/01/31  16:31:02  thoth
// renaming exit_on_throw.
// adding some convenience functions that make it easy to
// document an internal error or NYI.
// new exceptions for ia_throw.
// new version of ia_throw that takes an object.
//
// Revision 1.27  1993/11/16  13:25:29  thoth
// Add PNM IO error.
//
// Revision 1.26  1993/09/24  14:22:40  jnw
// Added version define constants and IA:: class version data members
//
// Revision 1.25  93/09/15  12:23:30  thoth
// Some pointset behavior controls.
// 
// Revision 1.24  93/05/26  16:28:17  thoth
// Copyright Notices.
// 
// Revision 1.23  93/05/26  16:04:21  thoth
// New Error type for IAAIO
// 
// Revision 1.22  92/10/05  16:56:21  jnw
// Added error names
// 
// Revision 1.21  92/09/30  12:22:54  jnw
// Added some error literals
// 
// Revision 1.20  92/09/17  09:53:31  jnw
// added LatticeRelation to class IA
// 
// Revision 1.19  92/08/26  14:56:43  thoth
// new error types for PointSets
// 
// Revision 1.18  92/08/19  17:16:19  jnw
// Changed throw to ia_throw for compatibility with CFront 3.0.1
// 
// Revision 1.17  92/07/16  12:36:32  thoth
// removed stuff dealing with Coords.
// added INVALID_OPERATION error
// 
// Revision 1.16  92/07/13  13:53:24  thoth
// we used iostream stuff, so we now include iostream.h
// 
// Revision 1.15  92/06/27  23:45:53  fischer
// Added new error enum for concatenation operator, POINT_TOO_LARGE.
// 
// Revision 1.14  92/06/26  14:45:22  fischer
// Added COORD_UNINITIALIZED and POINT_UNINITIALIZED to
// Error enums for cases of arithmetic or relational tests
// on empty Points or unintialized Coords.
// 
// Revision 1.13  92/06/17  14:17:22  thoth
// throw is no longer volatile, it can return.
// 
// Revision 1.12  92/06/17  14:02:00  thoth
// made the exit_on_throw optional, now controlled by
// static member variable of the IA class.
// 
// Revision 1.11  92/06/16  13:53:09  thoth
// updated enums to follow new conventions
// 
// Revision 1.10  92/06/15  14:01:41  thoth
// made NumericType a nested class of IA,
// upcased all the enum constants.
// 
// Revision 1.9  92/06/15  13:10:51  fischer
// Experiments with getting the NumericType enums in IA class.
// So far failed.
// 
// Revision 1.8  92/06/15  12:40:39  fischer
// Renamed enum type literals to uppercase and
// changed Float to REAL.
// 
// Revision 1.7  92/06/05  01:10:32  fischer
// Added comments for ContagionTable construction.
// 
// Revision 1.6  92/05/26  07:40:16  fischer
// *** empty log message ***
// 
// Revision 1.6  1992/05/26  11:35:24  fischer
// Made NumericType have a print method, added PointIndexMismatch.
//
// Revision 1.5  1992/05/21  20:21:16  thoth
// switch to // comments
//
// Revision 1.4  92/05/21  12:10:28  thoth
// change the CoordType to NumericType and
// added static member functions to compute
// conversion conventions.
// 
// Revision 1.3  92/05/18  11:47:59  thoth
// rearranged the CoordType so that None can
// be used as the number of other enums.
//  
// Revision 1.2  92/05/16  13:58:11  thoth
// added log goo
//  

#ifdef __GNUC__
#define VOL_F	volatile
#else
#define VOL_F
#endif

#define IA_MAJOR_VERSION_NUMBER 0
#define IA_MINOR_VERSION_NUMBER 10

#include <iostream.h>

struct IA {

    typedef const char* const Type;

    struct Exception {
	const char	*filename;
	int	line;
	Exception(const char *fname, int l):filename(fname),line(l) {}

	virtual ostream &diagnose(ostream&) const =0;
    };

    enum Error {
	TYPE_MISMATCH, TYPE_UNSPECIFIED,
	POINT_INDEX_MISMATCH, POINT_UNINITIALIZED, POINT_TOO_LARGE,
	PSET_REQUIRE_EXTENSIVE, PSET_DIMENSION_MISMATCH,
	PSET_INDEX_UNCONTAINED, PSET_SIZE_MISMATCH,
	INVALID_OPERATION,
	IMAGE_REQUIRE_VALUE, IMAGE_REQUIRE_EXTENSIVE,
	IMAGE_STRUCTURE_NOT_SUPPORTED, PSET_MISMATCH,
	IMAGE_DOMAIN_ERROR, IMAGE_REQUIRE_VALUE_ITER,
	IMAGE_REQUIRE_PIXEL_ITER,
	IMAGE_VECTOR_CNSTR_SZMISMATCH,
	IMAGE_POINT_OUTSIDE_DOMAIN,
	IAAIO_FORMAT_ERROR, PNM_IO_ERROR,
    };
    
    // enum LatticeRelation was designed for use by comparison functions for
    // Sets with possibly comprehensive representations.  It is, however,
    // applicable to any kind of lattice with comprehensive representation,
    // thus, we should consider renaming the elements to remove the "set"
    // designations.
    //
    // P_	indicates proper containment
    // MP_	indicates _maybe_ proper containment (i.e. containment is
    //		known but properness cannot be determined).

    enum LatticeRelation {
	P_SUBSET, MP_SUBSET, EQUAL, MP_SUPERSET, P_SUPERSET, NO_REL, UNKNOWN
	};
    
    static int abort_on_throw;

    // If this variable is non-zero, then an index() operation on an
    // uncontained point will throw.  It is non-zero by default.
    static char throw_on_index_uncontained;
    // If the argument to an index() operation is not contained in
    // in the point set, the return value (if any) will be this:
    static const unsigned index_of_uncontained;
    // CFront is totally braindead about static const member variables.

    // Run-time accessible version number information
    static const int major_version_number;
    static const int minor_version_number;

    static VOL_F void internal_error(char *file, int line);
    static VOL_F void not_yet_implemented(char *file, int line);
};

// this will have to do until CFront and others supports exceptions

VOL_F void ia_throw(IA::Error, char*file, int line);
VOL_F void ia_throw(const IA::Exception &);
// throw CAN return if abort_on_throw is 0

struct GenericException:public IA::Exception {
    const char	*explanation;
    GenericException(const char *excuse, const char *fname, int l)
	:IA::Exception(fname, l), explanation(excuse) {}
    ostream &diagnose(ostream&) const;
};

#endif
