// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char rcsid_Array[] = "$Id: Array.c,v 1.3 1993/05/26 16:28:19 thoth Exp $";

// 
// $Log: Array.c,v $
// Revision 1.3  1993/05/26  16:28:19  thoth
// Copyright Notices.
//
// Revision 1.2  93/05/19  14:42:16  thoth
// Renamed to IA_Array.
// new operator() which is const.
// 
// Revision 1.1  92/10/27  16:34:42  thoth
// Initial revision
// 
//

template <class T>
IA_Array<T>::IA_Array(unsigned size_)
{
    data = new T[size = size_];
    length = 0;
}



template <class T>
IA_Array<T>::IA_Array(T* data_, unsigned size_, int giveaway)
{
    length = size = size_;
    if (giveaway) {
	data = data_;
    } else {
	data = new T[size];
	for (unsigned i=0; i<length; i++)
	    data[i] = data_[i];
    }
}

template <class T>
IA_Array<T>::IA_Array(const IA_Array<T> &arr)
{
    length = size = arr.length;
    data = new T[size];
    for (unsigned i=0; i<length; i++)
	data[i] = arr.data[i];
}

template <class T>
IA_Array<T>& IA_Array<T>::operator=(const IA_Array<T> &arr)
{
    if (this == &arr) {
	// a = a;
	return *this;
    }

    delete[] data;
    length = size = arr.length;
    data = new T[size];
    for (unsigned i=0; i<length; i++) {
	data[i] = arr.data[i];
    }

    return *this;
}


template <class T>
T& IA_Array<T>::operator[](unsigned idx)
{
    unsigned	beyond = idx+1;
    if (beyond>size) {
	resize(size*2>beyond? size*2 : beyond*2);
    }
    if (idx>=length)
	length = beyond;
    return data[idx];
}

template <class T>
T IA_Array<T>::operator[](unsigned idx) const
{
    //return (idx>=size)?T():data[idx];
    if (idx>=size) {
	T	rval;
	return rval;
    } else
	return data[idx];
}

template <class T>
T IA_Array<T>::operator()(unsigned idx) const
{
    //return (idx>=size)?T():data[idx];
    if (idx>=size) {
	T	rval;
	return rval;
    } else
	return data[idx];
}

template <class T>
unsigned IA_Array<T>::shorten(unsigned newlen)
{
    unsigned	rval = length;
    if (newlen<length)
	length = newlen;
    return rval;
}

template <class T>
unsigned IA_Array<T>::lengthen(unsigned newlen)
{
    unsigned	rval = length;
    if (newlen>size)
	resize(newlen);
    if (newlen>length)
	length = newlen;
    return rval;
}

template <class T>
unsigned IA_Array<T>::resize(unsigned newsize)
{
    unsigned oldsize=size;
    T	*newdata = new T[newsize];

    // copy the data we already have.
    for (unsigned i=0; i<length && i<newsize; i++)
	newdata[i] = data[i];

    // maybe truncate
    length = i;

    delete[] data;
    size = newsize;
    data = newdata;

    return oldsize;
}
