// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: Image.h,v $
// Revision 1.4  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.3  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.2  1994/05/27  15:32:50  thoth
// We had forgotten the RGBDI specialization.
//
// Revision 1.1  1994/01/31  16:43:38  thoth
// Initial revision
//

#ifndef Image_h_
#define Image_h_

#include "Set.h"

template <class P, class T> class IA_Image {
private:
    IA_Image();
    IA_Image(const IA_Image&);
    IA_Image(const IA_Set<P>&, T*, unsigned, int);
    IA_Image(const IA_Set<P>&, T);
    ~IA_Image();

    IA_Image & operator=(const IA_Image &);
#if 0				// if only we could forward declare a
				// specialization...
    T & operator[](const P&);

    IA_Set<P> domain() const;
#endif
};

#ifndef SUPPRESS_INCLUDE
#include "BitDI.h"
#include "UcharDI.h"
#include "IntDI.h"
#include "FloatDI.h"
#include "CplxDI.h"
#include "RGBDI.h"
#include "FloatCI.h"
#else

#if 0
#include "Bit.h"
#include <complex.h>
class IA_Image<IA_Point<int>,IA_Bit>;
class IA_Image<IA_Point<int>,u_char>;
class IA_Image<IA_Point<int>,int>;
class IA_Image<IA_Point<int>,float>;
class IA_Image<IA_Point<int>,complex>;

class IA_Image<IA_Point<double>,float>;
#endif

#endif

#endif //Image_h_
