//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: bit-conv.desc,v $
// Revision 1.3  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.2  1993/12/29  17:16:45  thoth
// Bit Discrete Image now uses Bit type.
//
// Revision 1.1  1993/11/29  22:25:25  thoth
// Initial revision
//
// 
// The XOR for the hit-miss transform is implemented using logical operators
// instead of the bitwise '^' to guarantee that only values of 1 and 0
// result.
// convolution hit_miss zero=1 I(IA_Bit) I(IA_Bit) T(IA_Bit)
IA_Image<IA_Point<int>, IA_Bit> hit_miss(const IA_CoreImage<IA_Point<int>,IA_Bit> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, IA_Bit> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, IA_Bit> hit_miss(const IA_CoreImage<IA_Point<int>,IA_Bit> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>, IA_Bit> > &templ) {
    return hit_miss(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution hit_miss zero=1 I(IA_Bit) T(IA_Bit) I(IA_Bit)
IA_Image<IA_Point<int>, IA_Bit> hit_miss(const IA_DDTemplate<IA_Image<IA_Point<int>, IA_Bit> > &templ,
		const IA_CoreImage<IA_Point<int>,IA_Bit> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>, IA_Bit> hit_miss(const IA_DDTemplate<IA_Image<IA_Point<int>, IA_Bit> > &templ,
		const IA_CoreImage<IA_Point<int>,IA_Bit> &img) {
    return hit_miss(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

