.so /research/devel/khaos/manual/utils/tmac.manual
.ds f. chpt1_vol2.man
.J2 1 "Writing Programs / VIFF Format"
.K2 1 "WRITING PROGRAMS / VIFF FORMAT" "Writing Programs Under the Khoros System"  "Danielle Argiro & Charlie Gage"
.K0 "WRITING PROGRAMS / VIFF FORMAT"
.sp
.NH 1 "OVERVIEW OF THE KHOROS PROGRAMMER'S MANUAL"
.XS
\s12\*(SN  OVERVIEW OF THE KHOROS PROGRAMMER'S MANUAL\s0
.XE
.sp
.PP
.PP
Volume II of the \fIKhoros Manuals\fP contains documentation for the 
program developer who wishes to create new applications using the Khoros 
user interface development tools.  
.PP
In simplest terms, a Khoros application consists of
application-specific algorithms which are accessed by an automatically
generated user interface based on a User Interface Specification (UIS).
The Khoros environment supports the creation of three types of user
interfaces: graphical, textual, and the visual language.
.PP
\fIChapter 2\fP provides an in-depth explanation of the use of the UIS file.
The first task for the application designer who wishes to develop
a Khoros program is to create a UIS file, so a careful study of this
chapter is important for anyone who wishes to develop a program under
the Khoros system. Information concerning
the physical appearance and functionality of an application interface
is contained here.  Designed as a high level description, the specification 
is used directly to generate the code for both the graphical and the 
command line user interfaces.
.PP
\fIChapter 3\fP gives instructions for the use of \fBpreview\fP, a program that
allows you to prototype the graphical user interface defined by a UIS.
.PP
\fIChapter 4\fP gives instructions for the use of \fBcomposer\fP, a program that
allows you to interactively edit a UIS file and a Program Specification (PS)
file. 
.PP
\fIChapter 5\fP details the use of the \fBghost routines\fP for automatic 
generation and maintenance of code for the command line user interface (CLUI) 
of a Khoros program.  Use of the \fBghost routines\fP is required for 
creation of any Khoros program.
.PP
\fIChapter 6\fP explains \fBconductor\fP, an automatic code generation program 
for xvroutines only. \fBConductor\fP generates the C code necessary
to mediate between the \fIxvforms\fP library and the application program's
graphical user interface.
.PP
\fIChapter 7\fP gives examples of xvroutines;  there is no need for additional 
examples of vroutines, as more than enough are available in the \fIvipl\fP
and \fIdspl\fP libraries.
.PP
\fIChapter 8\fP introduces the libraries which form the foundation on which the
Khoros system is based.  They provide utilities so that the program developer
may create applications under X Windows, Version 11, Release 4, while knowing
only a little about X programming.  For those who have already developed
programs using the Khoros libraries, changes to library routines are listed in
the first section.
.PP
\fIChapter 9\fP contains the documentation for the layout of of the Khoros 
Source Tree.  In addition, it gives details on the use of \fIMakefiles\fP 
and \fIImakefiles\fP.
.bp
.sp 2
.so /research/devel/khaos/manual/vol2/chpt1/intro.tbl
.so /research/devel/khaos/manual/vol2/chpt1/vroutines.tbl
.so /research/devel/khaos/manual/vol2/chpt1/xvroutines.tbl
.so /research/devel/khaos/manual/vol2/chpt1/convention.tbl
.so /research/devel/khaos/manual/vol2/chpt1/conclusion.tbl
.so /research/devel/khaos/manual/vol2/chpt1/viff.tbl
.TC 1 "WRITING PROGRAMS / VIFF FORMAT"
