.J2 1 "Writing Programs / VIFF Format"
.K2 1 "WRITING PROGRAMS / VIFF FORMAT" "Writing Programs Under the Khoros System"  "Danielle Argiro & Charlie Gage"
.K0 "WRITING PROGRAMS / VIFF FORMAT"
.sp
.NH 1 "OVERVIEW OF THE KHOROS PROGRAMMER'S MANUAL"
.XS
\s12\*(SN  OVERVIEW OF THE KHOROS PROGRAMMER'S MANUAL\s0
.XE
.sp
.PP
Volume II of the \fIKhoros Manuals\fP contains documentation for the 
program developer who wishes to create new applications using the Khoros 
user interface development tools and the source configuration tools.  
.PP
In simplest terms, a Khoros application consists of
application-specific algorithms which are accessed by an automatically
generated user interface based on a User Interface Specification (UIS).
The Khoros User Interface Development System  (UIDS)
supports the creation of three types of user
interfaces: graphical, textual, and the visual language.
.PP
The source configuration tools help you to maintain the extensions
that you have made to Khoros using the UIDS.  The software
engineering tools in Khoros embed conventions that we have chosen
and modern software practices.  The tools attempt to automate
complex tasks.  At this point in the evolution of Khoros, we are
partially successful in hiding the complexity from the user.
When a tool is complicated to use, we attempt in this manual to
document and explain how a user should proceed.
.PP
The underlying philosophy is that you are creating your extensions to
Khoros to have the characteristics of reusability and maintainability.
.sp 3
.NH 2 "CHAPTER SUMMARIES"
.XS
      \*(SN CHAPTER SUMMARIES 
.XE
.sp
.PP
\fIChapter 1\fP is where the Khoros programmer should begin.  If you are new
to Khoros, you should read through Chapter 1, then become familiar with
the rest of Volume II, and then read Chapter 1 again.
.PP
\fIChapter 2\fP provides an in-depth explanation of the use of the UIS file.
The first task for the application designer who wishes to develop
a Khoros program is to create a UIS file, so a careful study of this
chapter is important for anyone who wishes to develop a program under
the Khoros system. Information concerning
the physical appearance and functionality of an application interface
is contained here.  Designed as a high level description, the specification 
is used directly to generate the code for both the graphical and the 
command line user interfaces.
.PP
\fIChapter 3\fP gives instructions for the use of \fBpreview\fP, a program that
allows you to prototype the graphical user interface defined by a UIS.
.PP
\fIChapter 4\fP gives instructions for the use of \fBcomposer\fP, a program that
allows you to interactively edit a UIS file and a Program Specification (PS)
file. 
.PP
\fIChapter 5\fP details the use of the \fBghost routines\fP for automatic 
generation and maintenance of code for the command line user interface (CLUI) 
of a Khoros program.  Use of the \fBghost routines\fP is required for 
creation of any Khoros program.
.PP
\fIChapter 6\fP explains \fBconductor\fP, an automatic code generation program 
for xvroutines only. \fBConductor\fP generates the C code necessary
to mediate between the \fIxvforms\fP library and the application program's
graphical user interface.
.PP
\fIChapter 7\fP gives examples of xvroutines;  there is no need for additional 
examples of vroutines, as more than enough are available in the \fIvipl\fP
and \fIdspl\fP libraries.
.PP
\fIChapter 8\fP introduces the libraries which form the foundation on which the
Khoros system is based.  They provide utilities so that the program developer
may create applications under X Windows, Version 11, Release 4, while knowing
only a little about X programming.  For those who have already developed
programs using the Khoros libraries, changes to library routines are listed in
the first section.
.PP
\fIChapter 9\fP contains the documentation for the layout of of the Khoros 
Source Tree.  In addition, it gives details on the use of \fIMakefiles\fP 
and \fIImakefiles\fP.
.PP
\fIChapter 10\fP is the installation guide.  Yes we know - it should be
chapter 1.
.PP
\fIChapter 11\fP contains the documentation for \fBkraftsman\fP.
This chapter was added when we released patch 3 to Khoros 1.0.
.sp 3
.NH 2 "RECIPE FOR USING VOLUME II"
.XS
      \*(SN RECIPE FOR USING VOLUME II
.XE
.sp
.PP
Volume II is an integrated set of documents.  The order in which you
should learn them depends on what stage of development you are in and
what your goals are.  Ideally, you could get started using the tools
and the Khoros environment with out having to know all of the details
of the system.  Then as you begin to use the system, you can come
back to Volume II as you need.  The following recipe is for someone
new to Khoros and investigating the possibilities of using Khoros as
a software development environment.
.sp
.IP
\fB1) Get Familiar with Volume II - \fP
Read Chapter 1 sections A through I so that you can become familiar with
the terminology used and the tools that are available.  The details of
this material will not sink in until you begin programming.  Then, spend 
about an hour or two looking through the rest of Volume II, reading the
sections that look interesting.
.IP
\fB2) Experiment with Composer - \fP
Create yourself a work directory for experimenting with \fBcomposer\fP.
Create a user interface for a simple vroutine and use ghostwriter to 
generate code for it.  Do not attempt to install it yet.
Access your new routine via the \fBcantata\fP user interface as
described in Chapter 1.
.IP
\fB3) Read Chapter 1 Again - \fP  This time through Chapter 1, read the
documentation critically and try and understand most of the details.
You are now preparing yourself to completely install a new program
into the Khoros environment.
.IP
\fB4) Study Configuration Management - \fP
Most casual programmers are not familiar with configuration management and
lack a knowledge of Imake, etc.  But, if you want your software to
have the qualities it needs to be maintainable and usable by others, then
learn configuration management.  This material is in Chapter 9 of Volume II.
.IP
\fB5) Create a Toolbox - \fP
Following the instructions in Chapter 11 and Chapter 1, 
create a new toolbox.
.IP
\fB6) Write and Install a Simple Program - \fP
Use the simple program that you created in step 2) above and install it into
your toolbox.
.LP
Good Luck! 
.bp
.sp 2
.so KHOROS_HOME/manual/vol2/chpt1/intro.tbl
.so KHOROS_HOME/manual/vol2/chpt1/vroutines.tbl
.so KHOROS_HOME/manual/vol2/chpt1/xvroutines.tbl
.so KHOROS_HOME/manual/vol2/chpt1/convention.tbl
.so KHOROS_HOME/manual/vol2/chpt1/conclusion.tbl
.so KHOROS_HOME/manual/vol2/chpt1/viff.tbl
.TC 1 "WRITING PROGRAMS / VIFF FORMAT"
