.J1 2 Cantata
.K1 2 CANTATA "Visual Language Programming Environment" "Mark Young (programming) Carla Williams (doc)"
.K0 CANTATA
.NH 1 "INTRODUCTION"
.XS
\s12\*(SN  INTRODUCTION\s0
.XE
.sp 2
.LP
The purpose in providing a visual language interface to the data processing
programs included in the Khoros library is to increase 
the productivity of researchers and application developers.  
By providing a more natural environment, similar to the block
diagrams that are already familiar to practitioners in the field,
the system provides support to both novice and experienced programmers.
.sp 2
.NH 2 "ABOUT CANTATA"
.XS
      \*(SN  ABOUT CANTATA
.XE
.sp
.LP
\fBCantata\fP is a graphically expressed, data flow oriented language which
provides a visual programming environment within the Khoros system.
Data flow is a "naturally visible" approach in which a program is
described as a directed graph, where each node represents an operator
(or function) and each directed arc represents a path over which
data tokens flow.  In the data-driven model, execution of a node
occurs whenever all its input data tokens are available.  The result
is placed on the node's output arc(s) and flows on to the next node for
processing.  
.PP
In \fBcantata\fP, the nodes represent processing routines from
the Khoros libraries and the tokens represent data to be processed by the nodes.
To create a \fBcantata\fP application, the user selects the desired
programs (and control structures, as needed), places
the corresponding glyph icons on the workspace, and interconnects these
elements to indicate the flow of processing from routine to routine.
The graphical programming elements of the visual language consist of the
workspace \fImaster form\fP and a flow graph based on connected 
\fIglyphs\fP, as described in the following sections.
.sp 2
.NH 2 "CANTATA MASTER FORM"
.XS
      \*(SN  CANTATA MASTER FORM
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/Overview.doc
.sp 2
.NH 1 "PROGRAM SUBFORMS"
.XS
\s12\*(SN  PROGRAM SUBFORMS\s0
.XE
.sp 2
.so KHOROS_HOME/doc/cantata/master_help/Subforms.doc
.sp 2
.NH 2 "SUBFORM USAGE"
.XS
      \*(SN  SUBFORM USAGE
.XE
.sp
.so KHOROS_HOME/doc/cantata/subforms/Forms/Usage.doc
.sp 2
.NH 3 "Subform Guide Pane"
.XS
              \*(SN  Subform Guide Pane
.XE
.sp
.so KHOROS_HOME/doc/cantata/subforms/Forms/guide.doc
.sp 2
.NH 3 "Setting Program Parameters"
.XS
              \*(SN  Setting Program Parameters
.XE
.sp
.so KHOROS_HOME/doc/cantata/subforms/Forms/pane.doc
.sp 2
.NH 3 "Subform Glyph Button"
.XS
              \*(SN  Subform Glyph Button
.XE
.sp
.so KHOROS_HOME/doc/cantata/subforms/Forms/glyph.doc
.sp 2
.NH 2 "USING CANTATA TO CONSTRUCT A VISUAL PROGRAM"
.XS
      \*(SN  USING CANTATA TO CONSTRUCT A VISUAL PROGRAM
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/Usage.doc
.sp 3
.NH 1 "MASTER ACTION BUTTONS"
.XS
\s12\*(SN  MASTER ACTION BUTTONS\s0
.XE
.sp 2
.LP
The action buttons on the master form provide the basic operations needed for
the creation of and execution of processing flow graphs.
.sp 2
.NH 2 "ROUTINES MASTER ACTION BUTTON"
.XS
      \*(SN  ROUTINES MASTER ACTION BUTTON
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/routines.doc
.sp 2
.NH 2 "RUN AND RESET MASTER ACTION BUTTON"
.XS
      \*(SN  RUN AND RESET MASTER ACTION BUTTON
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/run.doc
.sp 2
.NH 2 "QUIT MASTER ACTION BUTTON"
.XS
      \*(SN  QUIT MASTER ACTION BUTTON
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/quit.doc
.sp 2
.NH 2 "MASTER FORM GLYPH BUTTON"
.XS
      \*(SN  MASTER FORM GLYPH BUTTON
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/glyph.doc
.sp 2
.NH 2 "TUTORIAL: CREATING A CANTATA PROGRAM"
.XS
      \*(SN  TUTORIAL: CREATING A CANTATA PROGRAM
.XE
.sp
.so KHOROS_HOME/doc/cantata/master_help/tutorial.doc
.sp 3
.NH 1 "INTERACTION SUBFORMS"
.XS
\s12\*(SN  INTERACTION SUBFORMS\s0
.XE
.sp 2
.LP
Interaction subform buttons are located on the top-left and left side 
of the \fBcantata\fP
master form (as opposed to the program subform menu buttons which
are located along the top of the master form).  Clicking the mouse on a
subform button, such as `Variables', brings up the corresponding subform.  
Clicking the mouse on a subform menu button, such as `Edit' or `Workspace', 
pops up 
a drop down menu of selections that can be immediate actions or subform
actions.
The following section may be skipped initially, as it contains the information
needed for more advanced \fBcantata\fP programming.
.sp 2
.NH 2 "WORKSPACE ATTRIBUTES AND UTILITIES"
.XS
      \*(SN  WORKSPACE ATTRIBUTES AND UTILITIES
.XE
.sp
.so KHOROS_HOME/doc/cantata/workspace/Overview.doc
.sp 2
.NH 3 "Saving Temporary Files"
.XS
              \*(SN  Saving Temporary Files
.XE
.sp
.so KHOROS_HOME/doc/cantata/workspace/save_files.doc
.sp 2
.NH 3 "Workspace File Utilities"
.XS
              \*(SN  Workspace File Utilities
.XE
.sp
.so KHOROS_HOME/doc/cantata/workspace/file_utils/Overview.doc
.LP
.so KHOROS_HOME/doc/cantata/workspace/file_utils/temp_files.doc
.sp 2
.NH 3 "Setting Workspace Attributes"
.XS
              \*(SN  Setting Workspace Attributes
.XE
.sp
.so KHOROS_HOME/doc/cantata/workspace/attributes/Overview.doc
.sp 2
.NH 3 "Setting Workspace Attributes via Xdefaults"
.XS
              \*(SN  Setting Workspace Attributes via Xdefaults
.XE
.sp
.so KHOROS_HOME/doc/cantata/workspace/attributes/xdefaults.doc
.sp 2
.NH 2 "USING DATA TRANSPORT / DISTRIBUTED PROCESSING"
.XS
      \*(SN  USING DATA TRANSPORT / DISTRIBUTED PROCESSING
.XE
.sp
.so KHOROS_HOME/doc/cantata/workspace/attributes/dist_proc.doc
.sp 2
.NH 2 "WORKSPACE EDITING / SUBPROCEDURES"
.XS
      \*(SN  WORKSPACE EDITING / SUBPROCEDURES
.XE
.sp 2
.NH 3 "Workspace Editing"
.XS
              \*(SN  Workspace Editing
.XE
.sp
.so KHOROS_HOME/doc/cantata/edit/Overview.doc
.sp 2
.NH 3 "Procedures"
.XS
              \*(SN  Procedures
.XE
.sp
.so KHOROS_HOME/doc/cantata/edit/procedures.doc
.sp 2
.NH 3 "Saving Glyphs or Procedures"
.XS
              \*(SN  Saving Glyphs or Procedures
.XE
.sp
.so KHOROS_HOME/doc/cantata/edit/save.doc
.sp 2
.NH 2 "DEFINE VARIABLES / EVALUATE EXPRESSIONS"
.XS
      \*(SN  DEFINE VARIABLES / EVALUATE EXPRESSIONS
.XE
.sp
.so KHOROS_HOME/doc/cantata/variables/Overview.doc
.SH
DEFINING VARIABLES
.so KHOROS_HOME/doc/cantata/variables/Usage.doc
.sp 2
.NH 3 "Arithmetic Operators"
.XS
              \*(SN  Arithmetic Operators
.XE
.sp
.so KHOROS_HOME/doc/cantata/variables/operators.doc
.sp 2
.NH 3 "Logical Operators"
.XS
              \*(SN  Logical Operators
.XE
.sp
.so KHOROS_HOME/doc/cantata/variables/logicals.doc
.sp 2
.NH 3 "Predefined Constants"
.XS
              \*(SN  Predefined Constants
.XE
.sp
.so KHOROS_HOME/doc/cantata/variables/constants.doc
.sp 2
.NH 3 "Functions"
.XS
              \*(SN  Functions
.XE
.sp
.so KHOROS_HOME/doc/cantata/variables/functions.doc
.sp 3
.NH 2 "PROGRAM FLOW CONTROL / UTILITIES"
.XS
      \*(SN  PROGRAM FLOW CONTROL
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/Overview.doc
.sp 2
.NH 3 "COUNT-LOOP Control Structure"
.XS
              \*(SN  COUNT-LOOP Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/count_loop/Count_Loop.doc
.sp
.SH
COUNT-LOOP EXAMPLES
.so KHOROS_HOME/doc/cantata/control/count_loop/loop_examples.doc
.sp
.NH 3 "WHILE-LOOP Control Structure"
.XS
              \*(SN  WHILE-LOOP Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/while_loop/While_Loop.doc
.sp
.SH
WHILE-LOOP EXAMPLES
.so KHOROS_HOME/doc/cantata/control/while_loop/loop_examples.doc
.sp
.NH 3 "IF-THEN-ELSE Control Structure"
.XS
              \*(SN  IF-THEN-ELSE Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/if_else/If_Then_Else.doc
.sp
.SH
IF-THEN-ELSE EXAMPLES
.so KHOROS_HOME/doc/cantata/control/if_else/If_examples.doc
.sp
.NH 3 "MERGE Control Structure"
.XS
              \*(SN  MERGE Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/merge/merge.doc
.sp
.NH 3 "TRIGGER Control Structure"
.XS
              \*(SN  TRIGGER Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/trigger/trigger.doc
.sp
.SH
TRIGGER EXAMPLES
.so KHOROS_HOME/doc/cantata/control/trigger/trigger_example.doc
.sp
.NH 3 "EXPRESSION Control Structure"
.XS
              \*(SN  EXPRESSION Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/expression/expression.doc
.sp
.SH
EXPRESSION EXAMPLES
.so KHOROS_HOME/doc/cantata/control/expression/expr_example.doc
.sp
.NH 3 "SWITCH Control Structure"
.XS
              \*(SN  SWITCH Control Structure
.XE
.sp
.so KHOROS_HOME/doc/cantata/control/switch/switch.doc
.sp
.SH
SWITCH EXAMPLES
.so KHOROS_HOME/doc/cantata/control/switch/switch_example.doc
.sp
.NH 3 "Command Glyph"
.XS
              \*(SN  Command Glyph
.XE
.sp
.so KHOROS_HOME/doc/cantata/edit/command/command.doc
.sp
.so KHOROS_HOME/doc/cantata/edit/command/examples.doc
.sp
.NH 3 "Comment Glyph"
.XS
              \*(SN  Comment Glyph
.XE
.sp
.so KHOROS_HOME/doc/cantata/edit/comment/comment.doc
.bp
.sp 3
.NH 1 "AVAILABLE ROUTINES"
.XS
\s12\*(SN  AVAILABLE ROUTINES\s0
.XE
.sp 2
.LP
The following sections give an overview of the data processing
programs currently available on each of the Program Subforms 
within \fBcantata\fP.
.sp 2
.NH 2 "INPUT SOURCES Menu"
.XS
      \*(SN  INPUT SOURCES Menu
.XE
.sp 2
.NH 3 "Input Data Files"
.XS
              \*(SN  Input Data Files
.XE
.so KHOROS_HOME/doc/cantata/subforms/input_file/Overview.doc
.sp 2
.NH 3 "Create Image (2D)"
.XS
              \*(SN  Create Image (2D)
.XE
.so KHOROS_HOME/doc/cantata/subforms/inputcreate2D/Overview.doc
.sp 2
.NH 3 "Create Signal (1D)"
.XS
              \*(SN  Create Signal (1D)
.XE
.so KHOROS_HOME/doc/cantata/subforms/inputcreate1D/Overview.doc
.sp 2
.NH 2 "OUTPUT Menu"
.XS
      \*(SN  OUTPUT Menu
.XE
.sp 2
.NH 3 "Information about Data"
.XS
              \*(SN  Information
.XE
.so KHOROS_HOME/doc/cantata/subforms/info/Overview.doc
.sp 2
.NH 3 "Display Images"
.XS
              \*(SN  Display Images
.XE
.so KHOROS_HOME/doc/cantata/subforms/outputdisplay/Overview.doc
.sp 2
.NH 3 "Plot Data"
.XS
              \*(SN  Plot Data
.XE
.so KHOROS_HOME/doc/cantata/subforms/output_plot/Overview.doc
.sp 2
.NH 3 "Print Images"
.XS
              \*(SN  Print Images
.XE
.so KHOROS_HOME/doc/cantata/subforms/output_print/Overview.doc
.sp 2
.NH 3 "Dither"
.XS
              \*(SN  Dither
.XE
.so KHOROS_HOME/doc/cantata/subforms/output_dither/Overview.doc
.sp 2
.NH 2 "CONVERSIONS Menu"
.XS
      \*(SN  CONVERSIONS Menu
.XE
.sp 2
.NH 3 "Data Structure and Type Conversion"
.XS
              \*(SN  Data Structure and Type Conversion
.XE
.so KHOROS_HOME/doc/cantata/subforms/convert_data/Overview.doc
.sp 2
.NH 3 "Standard File Formats"
.XS
              \*(SN  Standard File Formats
.XE
.so KHOROS_HOME/doc/cantata/subforms/stndrd_format/Overview.doc
.sp 2
.NH 3 "Remote Sensing and GIS File Formats"
.XS
              \*(SN  Remote Sensing and GIS File Formats
.XE
.so KHOROS_HOME/doc/cantata/subforms/gis_format/Overview.doc
.sp 2
.NH 3 "Raw File Formats"
.XS
              \*(SN  Raw File Formats
.XE
.so KHOROS_HOME/doc/cantata/subforms/no_format/Overview.doc
.sp 2
.NH 3 "Color Transformations"
.XS
              \*(SN  Color Transformations
.XE
.so KHOROS_HOME/doc/cantata/subforms/convert_color/Overview.doc
.sp 2
.NH 3 "Maps and LUTs"
.XS
              \*(SN  Maps and LUTs
.XE
.so KHOROS_HOME/doc/cantata/subforms/map/Overview.doc
.sp 2
.NH 3 "Compress"
.XS
              \*(SN  Compress
.XE
.so KHOROS_HOME/doc/cantata/subforms/convert_compr/Overview.doc
.sp 2
.NH 2 "ARITHMETIC Menu"
.XS
      \*(SN  ARITHMETIC Menu
.XE
.sp 2
.NH 3 "Unary Arithmetic"
.XS
              \*(SN  Unary Arithmetic
.XE
.so KHOROS_HOME/doc/cantata/subforms/arith_unary/Overview.doc
.sp 2
.NH 3 "Binary Arithmetic"
.XS
              \*(SN  Binary Arithmetic
.XE
.so KHOROS_HOME/doc/cantata/subforms/arith_binary/Overview.doc
.sp 2
.NH 3 "Logical Operations"
.XS
              \*(SN  Logical Operations
.XE
.so KHOROS_HOME/doc/cantata/subforms/arith_logical/Overview.doc
.sp 2
.NH 3 "Matrix Algebra"
.XS
              \*(SN  Matrix Algebra
.XE
.so KHOROS_HOME/doc/cantata/subforms/matrixalgebra/Overview.doc
.sp 2
.NH 2 "IMAGE PROCESSING Menu"
.XS
      \*(SN  IMAGE PROCESSING Menu
.XE
.sp 2
.NH 3 "2D Spatial Domain Filters"
.XS
              \*(SN  2D Spatial Domain Filters
.XE
.so KHOROS_HOME/doc/cantata/subforms/filter2Dspatl/Overview.doc
.sp 2
.NH 3 "Morphological Operations"
.XS
              \*(SN  Morphological Operations
.XE
.so KHOROS_HOME/doc/cantata/subforms/filter_morph/Overview.doc
.sp 2
.NH 3 "2D Transforms"
.XS
              \*(SN  2D Transforms
.XE
.so KHOROS_HOME/doc/cantata/subforms/transform2D/Overview.doc
.sp 2
.NH 3 "2D Frequency Domain Filters"
.XS
              \*(SN  2D Frequency Domain Filters
.XE
.so KHOROS_HOME/doc/cantata/subforms/filter_2Dfreq/Overview.doc
.sp 2
.NH 3 "Histograms"
.XS
              \*(SN  Histograms
.XE
.so KHOROS_HOME/doc/cantata/subforms/histogram/Overview.doc
.sp 2
.NH 3 "Geometric Manipulations"
.XS
              \*(SN  Geometric Manipulations
.XE
.so KHOROS_HOME/doc/cantata/subforms/geomanip/Overview.doc
.sp 2
.NH 3 "Subimage/Subsignal Operations"
.XS
              \*(SN  Subimage/Subsignal Operations
.XE
.so KHOROS_HOME/doc/cantata/subforms/subregion/Overview.doc
.sp 2
.NH 2 "SIGNAL ANALYSIS Menu"
.XS
      \*(SN  SIGNAL ANALYSIS Menu
.XE
.sp 2
.NH 3 "Segmentation"
.XS
              \*(SN  Segmentation  
.XE
.so KHOROS_HOME/doc/cantata/subforms/segment/Overview.doc
.sp 2
.NH 3 "Feature Extraction"
.XS
              \*(SN  Feature Extraction
.XE
.so KHOROS_HOME/doc/cantata/subforms/feature/Overview.doc
.sp 2
.NH 3 "Classification/Clustering Algorithms"
.XS
              \*(SN  Classification/Clustering Algorithms
.XE
.so KHOROS_HOME/doc/cantata/subforms/classify/Overview.doc
.sp 2
.NH 2 "SIGNAL PROCESSING Menu"
.XS
      \*(SN  SIGNAL PROCESSING Menu
.XE
.sp 2
.NH 3 "Modify 1D Sequences"
.XS
              \*(SN  Modify 1D Sequences
.XE
.so KHOROS_HOME/doc/cantata/subforms/modify_seq1D/Overview.doc
.sp 2
.NH 3 "1D Transforms"
.XS
              \*(SN  1D Transforms
.XE
.so KHOROS_HOME/doc/cantata/subforms/transform1D/Overview.doc
.sp 2
.NH 3 "1D Time Domain Filters"
.XS
              \*(SN  1D Time Domain Filters
.XE
.so KHOROS_HOME/doc/cantata/subforms/filter_1Dtime/Overview.doc
.sp 2
.NH 3 "1D Frequency Domain Filters"
.XS
              \*(SN  1D Frequency Domain Filters
.XE
.so KHOROS_HOME/doc/cantata/subforms/filter_1Dfreq/Overview.doc
.sp 2
.NH 3 "1D Linear Operations"
.XS
              \*(SN  1D Linear Operations
.XE
.so KHOROS_HOME/doc/cantata/subforms/linearop1D/Overview.doc
.sp 2
.NH 3 "Spectral Estimation"
.XS
              \*(SN  Spectral Estimation
.XE
.so KHOROS_HOME/doc/cantata/subforms/spectest1D/Overview.doc
.sp 2
.NH 2 "CONTRIBUTED Menu"
.XS
      \*(SN  CONTRIBUTED Menu
.XE
.so KHOROS_HOME/doc/cantata/subforms/contrib/Overview.doc
.sp 2
.NH 3 "Contributed (Example)"
.XS
              \*(SN  Contributed (Example)
.XE
.so KHOROS_HOME/doc/cantata/subforms/contrib/contrib.doc
.sp 2
.NH 2 "REMOTE & GIS Menu"
.XS
      \*(SN  REMOTE & GIS Menu
.XE
.sp 2
.NH 3 "Image Warping"
.XS
              \*(SN  Image Warping
.XE
.so KHOROS_HOME/doc/cantata/subforms/gis_warp/Overview.doc
.sp 2
.NH 3 "Surface Manipulation"
.XS
              \*(SN  Surface Manipulation Menu
.XE
.so KHOROS_HOME/doc/cantata/subforms/gis_surface/Overview.doc
.sp 2
.NH 3 "GIS Vector Data"
.XS
              \*(SN  GIS Vector Data Menu
.XE
.so KHOROS_HOME/doc/cantata/subforms/gis_vector/Overview.doc

.TC 2 CANTATA
