// closure-otsu.c       Section: 3.7
// Threshold Selection by Maximizing Between Class Variance
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//
// Force instantiations of otsu() for UDI & IDI


#include "otsu.h"


int  main() {

    IA_Image<IA_Point<int>,u_char>
	udi = read_uchar_PGM(cin);

    IA_Image<IA_Point<int>,int>  idi( udi );

    IA_Set<IA_Point<int> >       tau_ps;

    unsigned int partitionCount = 2;    // Any value > 1 is ok
    // Force the UDI instantiation
    tau_ps = otsu( partitionCount, udi );

    // Force the IDI instantiation
    tau_ps = otsu( partitionCount, idi );

    cout << "Instantiations forced for otsu(), UDI & IDI" << endl;

    return 0;
}
