// closure-scale.c
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Force instantiation of the scale_to_uchar() function
//      for both IDI and FDI images.
// The images are scaled into the [0..255] u_char value range,
//      by using a simple linear scaling.

#include "scale-to-uchar.h"

void main() {

    IA_Image<IA_Point<int>,u_char>  im = read_uchar_PGM( cin );

    IA_Image<IA_Point<int>,int>     idi( im );
    IA_Image<IA_Point<int>,float>   fdi( im );

    im = scale_to_uchar( idi );
    display( im );
    im = scale_to_uchar( fdi );
    display( im );
}
