// gauss.h
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// This program was copied from "Numerical recipes in C",
//    used to generate Gauss noise signal  */
// This code was originally developed by: Juan Jose Murillo
//    modifications by: Ralph J. Jackson  <rjj@cis.ufl.edu>

#ifndef _gaussdev_h_
#define _gaussdev_h_

#include "Closure.h"

// This class it meant to be used to introduce Gaussian noise
//    into a float valued image.  To do this compose a
//    IA_Gauss object with the FDI.
//
class IA_Gauss : public IA_Closure<float, float> {
    const float mean, stdv, p_noise, min, max;

public:
    IA_Gauss( float _mean, float _stdv,
	      float _p_noise, float _min, float _max);

    float operator() (const float &v) const;

    IA_Closure<float, float>* clone_self() const;
};

#endif
