// closure-histogram.c  Section: 9.3 Histogram & 9.4 Cumulative Histogram
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//
// Force the creation of all reasonable histogram<P,T> functions.
//
// This program is NEVER mean to be executed.  It\'s sole purpose
//      is to force the instantiation of the related .o files
// It only seems reasonable to force instantiation for  IDI & UDI images
//      FDI\'s are conceivable, but would really require a FloatPointSet.
//      BDI\'s are also conceivable, however I would have to special case
//      them, because we do not have IA_Point<IA_Bit> type points.
// NOTE: histogram( BDI ) == sum( BDI ).


#include "ia.h"
#include "IntDI.h"
#include "FloatDI.h"
#include "UcharDI.h"

#include "histogram.h"


int  main() {
    // Never run this program...
    ia_throw( IA::INVALID_OPERATION, __FILE__, __LINE__ );

    IA_Image<IA_Point<int>,u_char>
	a = IA_Image<IA_Point<int>,u_char>::read_PGM(cin);

    IA_Image<IA_Point<int>,int>  h;

    h = histogram( a );
    h = cumulative_histogram( a );

    IA_Image<IA_Point<int>,float>  nh;

    nh = normalized_histogram( a );
    nh = normalized_cumulative_histogram( a );

    IA_Image<IA_Point<int>,int> b(a);
    h = histogram( b );
    h = cumulative_histogram( b );

    nh = normalized_histogram( b );
    nh = normalized_cumulative_histogram( b );

    return 0;
}
