// hough.h              Section: 10.3
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#ifndef _hough_h_
#define _hough_h_

#include "BitDI.h"
#include "UcharDI.h"
#include "IntDI.h"
#include "ClosureDT.h"


///////////////////////////////////////////////////////////////////////////
// Hough()
// This function simply creates a HoughTemplate based on the parameters
//    it is given, and then returns the template sum.
// Note that the accumulator image size will actually have
//    2*positive_rows_requested + 1  rows, and
//    columns_requested              columns

IA_Image<IA_Point<int>,int>
Hough( const IA_Image<IA_Point<int>,IA_Bit>,
       unsigned int positive_rows_requested,
       unsigned int columns_requested );



///////////////////////////////////////////////////////////////////////////
// class HoughTemplate
// This class is based on a ClosureDT<UDI> rather than a ClosureDT<BDI>.
// This is because the Hough algorithm essentially requires the
//    definition of the template over a BDI, but the iac++ library
//    can not sum such a template.  It can however, sum a template
//    based on UDI images.
// Hence this implementation claims to be based on a UDI.

class HoughTemplate: public IA_ClosureDT<IA_Image<IA_Point<int>,u_char> > {
private:
    IA_Image<IA_Point<int>,IA_Bit> b;  // Can not sum BDI
    double rows;   // Spans interval [-R,+R]
    double cols;   // Spans interval [0,pi)

    IA_Point<int> * ipa;  // Work array of IntPoints, length = cols
    IA_Point<int> b_inf;  // b.domain().inf(), we calcuate once here.
    double *sines, *cosines;  // Used to speed up calculations

public:

    const double R; // This may be seen, but not modified

    HoughTemplate( const IA_Image<IA_Point<int>,IA_Bit> & b_,
		   unsigned int positive_rows_requested,
		   unsigned int cols_requested );

    HoughTemplate( const HoughTemplate & );  // Need because we alloc memory

    ~HoughTemplate();

    IA_Image<IA_Point<int>,u_char>
    operator() ( const IA_Point<int> &) const;

    IA_ClosureDT<IA_Image<IA_Point<int>,u_char> > *
    clone_self() const;
};

#endif
