// max-min.c            Section: 2.6  Max-min Sharpening Transform
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Max-Min Sharpening Transform
//

#include "max-min.h"


///////////////////////////////////////////////////////////////////////
// max_min_sharpening()
// Implements the max-min-sharpening algorithm, with some minor
//      modifications. This version is implemented with neighborhoods,
//      and also includes interation count to allow the basic
//      algorithm to be applied many times within each call.

template <class P, class T>
IA_Image<P,T>
max_min_sharpening( const IA_Image<P,T> &image,
		    const IA_Neighborhood<P,P> &neighborhood,
		    const unsigned int iteration_count        ) {

    IA_Image<P,T>
	a(image),      // The original image, need a copy if iteration_count>0
	a_min, a_max, b,
	s(image);      // Initialize s in case iteration_count == 0;
    
    for (unsigned i=0; i<iteration_count; i++) {
	a_max = max(a, neighborhood);
	a_min = min(a, neighborhood);

        b = a_max + a_min - 2*a;

	s = IA_Image<P,T>(chi_le(b, 0))*a_max +
	    IA_Image<P,T>(chi_gt(b, 0))*a_min;
	
	a = s;  // Prepare for the next loop iteration.
    }
    
    return s;
}
