// MM_Specials.c        Section: 2.6  Max-min Sharpening Transform
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
// Max-Min Sharpening Transform special definition implementation file
//      this is where the UDI version of the max_min_sharpening()
//      algorithm is defined.

#include "max-min.h"



// A special definition for this function, as per
//       The C++ Programming Language, p. 272
// Here is the special definition for u_char ....
//

// IA_Image<P,u_char> is a special case because the max-min sharpening
//   algorithm might generate intermediate values that are < 0,
//   thus these results could not be stored in a u_char valued image.
//
IA_Image<IA_Point<int>,u_char>
max_min_sharpening( const IA_Image<IA_Point<int>,u_char> & image,
		    const IA_Neighborhood<IA_Point<int>,IA_Point<int> >
		    &neighborhood,
		    const unsigned int iteration_count ) {
    return
	to_uchar( max_min_sharpening( IA_Image<IA_Point<int>,int>( image ),
				      neighborhood, iteration_count ) );
}
