// File: inclusion-relation.c   Section: 12.4, Inclusion Relation
//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#include "inclusion-relation.h"
#include "holefill.h"
#include "BitDI.h"
#include "PSIter.h"


template <class P, class T>
IA_Image<P,T>
inclusion_relation( const IA_Image<P,T> & a ) {

    int   aMax = max( a );

    // Create the b image over the possible range values 
    IA_Image<P,T>
	b( IA_boxy_pset( P( 1, 1 ), P( aMax, aMax ) ),
	   T(1) );

    IA_PSIter<P>
	psiter( b.domain() );

    P p;

    // Iterate through b\'s domain filling in b\'s values.
    while( psiter( p ) ) {
	// Only consider non-diagonal points that are not zero already
	if ( (p(0) != p(1)) && (b(p) != 0) ) {
	    IA_Image<P,IA_Bit>
		ri    = chi_eq( a, T( p(0) ) ),
		rj    = chi_eq( a, T( p(1) ) ),
		rjbar = holefill( rj );

	    if ( ( ri & rjbar ) == rjbar ) {
		b[ derange(p,1,0) ] = T(0);
	    } else {
		b[ p              ] = T(0);
	    }
	}
    }

    return b;
}
