// Emacs -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: VSIter.c,v $
// Revision 1.2  1994/10/05  16:23:24  ljr
// added #include "VSIter.h" for BC++
//
// Revision 1.1  1994/10/03  21:01:43  thoth
// Initial revision
//

#include "VSIter.h"

template <class T>
IA_BaseSetIter<T> *
IA_ValueSetIter<T>:: clone_self() const
{
    return new IA_ValueSetIter<T>(*this);
}

template <class T>
int
IA_ValueSetIter<T>::curr(T &val) const
{
    if (idx >= vsp()->size)
	return 0;

    val = vsp()->value_array[idx];
    return 1;
}

template <class T>
int
IA_ValueSetIter<T>::done() const
{
    return idx >= vsp()->size;
}

template <class T>
int
IA_ValueSetIter<T>::next()
{
    if (idx >= vsp()->size)
	return 0;

    idx++;
    return 1;
}

template <class T>
int
IA_ValueSetIter<T>::next(T &val)
{
    if (idx >= vsp()->size)
	return 0;

    val = vsp()->value_array[idx++];
    return 1;
}

template <class T>
void
IA_ValueSetIter<T>::reset()
{
    idx = 0;
}
