// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: SetIter.h,v $
// Revision 1.1  1994/10/05  18:33:48  thoth
// Initial revision
//


#ifndef SetIter_h_
#define SetIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "Set.h"
#include "BSetIter.h"
//template <class T> class IA_BaseSetIter;

template <class T>
class IA_SetIter {
  protected:
    IA_BaseSetIter<T>	*iter;
    
  public:
    IA_SetIter();
    IA_SetIter(const IA_Set<T> &set) { this->iter = set.bsp->iterator(); }
    IA_SetIter(const IA_SetIter<T> &x) { this->iter = x.iter->clone_self(); }
    ~IA_SetIter() { delete iter; }
    
    IA_SetIter<T>& operator=(const IA_Set<T> &);
    IA_SetIter<T>& operator=(const IA_SetIter<T> &);
    
    IA_Set<T> domain() const { return iter->domain_(); }
    
    int curr(T& v) const	{ return iter->curr(v); }
    int done() const		{ return iter->done(); }
    int operator() ()		{ return iter->next(); }
    int operator() (T& v)	{ return iter->next(v); }
    void reset()		{ iter->reset(); }
};

/* sample usage:

   Set	blah;

   ...

   IA_SetIter<int>	scan(blah);
   int	i;

   while (scan(i)) {
     frob(i);
   }

 */

#endif
