// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: SetIter.c,v $
// Revision 1.1  1994/10/05  18:33:48  thoth
// Initial revision
//

#include "SetIter.h"

#ifdef IA_PRII
#pragma implementation
#endif


template <class T>
IA_SetIter<T>::IA_SetIter()
{
    iter = IA_Set<T>().bsp->iterator();
}


template <class T>
IA_SetIter<T> & IA_SetIter<T>::operator=(const IA_Set<T> &x)
{
    delete this->iter;

    this->iter = x.bsp->iterator();

    return *this;
}

template <class T>
IA_SetIter<T> & IA_SetIter<T>::operator=(const IA_SetIter<T> &x)
{
    if (x.iter==this->iter)
	return *this;

    delete this->iter;

    this->iter = x.iter->clone_self();

    return *this;
}
