// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: BaseSet.c,v $
// Revision 1.2.1.1  1994/12/08  14:41:15  thoth
// New extensive() method.
//
// Revision 1.2  1994/10/03  17:29:30  thoth
// Added support for iterators.
//
// Revision 1.1  1994/09/20  17:37:35  thoth
// Initial revision
//


#include "BaseSet.h"
#include "set_errors.h"

template <class T>
int IA_BaseSet<T>::extensive() const {
    return 0;
}

template <class T>
unsigned IA_BaseSet<T>::card() const {
    ia_throw(Set_Require_Extensive_Exception(__FILE__, __LINE__));
    return 0;
}

template <class T>
T IA_BaseSet<T>::min() const {
    ia_throw(Set_Require_Extensive_Exception(__FILE__, __LINE__));
    T	rval;
    return rval;
}

template <class T>
T IA_BaseSet<T>::max() const {
    ia_throw(Set_Require_Extensive_Exception(__FILE__, __LINE__));
    T	rval;
    return rval;
}

template <class T>
T IA_BaseSet<T>::choice() const {
    ia_throw(Set_Require_Extensive_Exception(__FILE__, __LINE__));
    T	rval;
    return rval;
}

template <class T>
int IA_BaseSet<T>::empty() const {
    ia_throw(Set_Require_Extensive_Exception(__FILE__, __LINE__));
    return 0;
}

template <class T>
IA_BaseSetIter<T> *
IA_BaseSet<T>::iterator() const {
    ia_throw(Set_Require_Extensive_Exception(__FILE__, __LINE__));
    return 0;
}
