// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: pset_errors.h,v $
// Revision 1.3  1994/05/08  19:37:45  thoth
// New intpointset decomposition capability.
//
// Revision 1.2  1994/04/15  13:11:53  thoth
// Added new exception to go with new array constructor.
//
// Revision 1.1  1994/02/01  13:52:46  thoth
// Initial revision
//

#ifndef pset_errors_h_
#define pset_errors_h_

struct Pointset_BadTranspose_Exception : public GenericException {
  Pointset_BadTranspose_Exception(const char *fn, int l)
    :GenericException
      ("Pointset: attempt to transpose a non-boxy or non-2-D pointset", fn, l) {}
};

struct Pointset_EmptyPointArray_Exception : public GenericException {
    Pointset_EmptyPointArray_Exception(const char *fn, int l)
	:GenericException
	    ("Pointset: attempt to build pointset from empty point array;  no way to compute dimension", fn, l) { }
};

struct Pointset_DecompFragBounds_Exception : public GenericException {
  Pointset_DecompFragBounds_Exception(const char *fn, int l)
    :GenericException
	    ("Pointset: Attempt to access non-existent frag from decomposition.  Index out of bounds", fn, l) { }
};

struct Pointset_RequireExtensive_Exception : public GenericException {
    Pointset_RequireExtensive_Exception (const char *fn, int l)
	:GenericException
	    ("Pointset: operation requires extensive pointset", fn, l) {}
};

struct Pointset_BadIndex_Exception : public GenericException {
    Pointset_BadIndex_Exception (const char *fn, int l)
	:GenericException
	    ("Pointset: bad index into set", fn, l) {}
};

struct Pointset_DimensionMismatch_Exception : public GenericException {
    Pointset_DimensionMismatch_Exception (const char *fn, int l)
	:GenericException
	    ("Pointset: dimension mismatch", fn, l) {}
};

struct Pointset_Empty_Exception : public GenericException {
    Pointset_Empty_Exception(const char *fn, int l) 
	:GenericException("Pointset: attempt to pick element from empty pointset", fn, l)
	    {}
};

#if 0
struct Pointset__Exception : public GenericException {
    Pointset__Exception (const char *fn, int l)
	:GenericException
	    ("Pointset: ", fn, l) {}
};
#endif

#endif // pset_errors_h_
