// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// 
// $Log: ListFPS.c,v $
// Revision 1.7  1994/10/04  18:14:23  thoth
// Convert to new Set iterator scheme.
//
// Revision 1.6  1994/10/03  20:22:55  fjsoria
// added IA_NO_AUTOINST_OF_STATIC_DATA guard
//
// Revision 1.5  1994/09/07  18:59:38  ljr
// added #include "ListFPS.h" for BC++
//
// Revision 1.4  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.3  1994/03/30  13:47:16  thoth
// Renamed files to BasePSIter.
//
// Revision 1.2  1994/01/31  16:38:40  thoth
// ValueSet now supports resetting of the iterator. We can do it
// in FloatPointSets now.
//
// Revision 1.1  1993/09/15  12:38:37  thoth
// Initial revision
//

#include "BasePSIter.h"
#include "../valueset/VSIter.h"
#include "ListFPS.h"

template <class P>
class IA_ListPSIter: public IA_BasePSIter<P> {
  private:
    IA_ListPSIter<P> &operator=(const IA_BasePSIter<P> &arg);
  protected:
    IA_BaseSetIter<P>	*iter;

  public:
    IA_ListPSIter(IA_ListPS<P> *ps)
    :IA_BasePSIter<P>(ps), iter(ps->points.iterator()) {
    }
    IA_ListPSIter(const IA_ListPSIter<P> &arg)
    :IA_BasePSIter<P>(arg.domain), iter(arg.iter->clone_self()) {
    }
    ~IA_ListPSIter() { delete iter; }

    IA_BasePSIter<P> *clone_self() {
	return new IA_ListPSIter<P>(*this);
    }

    int next(P&p) {
	return iter->next(p);
    }

    void reset() {
	iter->reset();
    }
};

#ifndef IA_NO_AUTOINST_OF_STATIC_DATA
template <class P>
char IA_ListPS<P>::dummy;
#endif



template <class P>
IA_BasePSIter<IA_Point<double> >* IA_ListPS<P>::iterator() const
{
  //cast
  return new IA_ListPSIter<P>((IA_ListPS<P>*)this);
}
