// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: BasePSIter.h,v $
// Revision 1.12  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.11  1994/03/30  13:47:16  thoth
// Renamed files to BasePSIter.
//
// Revision 1.10  1993/07/15  11:24:09  thoth
// Conversion to BasePSIter<P>.
// Uses IA_BasePS<P> * directly now with reference counting.
//
// Revision 1.9  93/05/26  16:40:53  thoth
// Copyright Notices.
// 
// Revision 1.8  93/04/17  14:52:59  thoth
// Use IA_IntPoint instead of IntPoint
// 
// Revision 1.7  93/02/12  16:21:14  thoth
// more comments
// 
// Revision 1.6  92/12/16  14:47:51  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.5  92/08/23  13:29:50  thoth
// CFrontified version
// 
// 

#ifndef BasePSIter_h_
#define BasePSIter_h_

#include "BasePS.h"

#ifdef IA_PRII
#pragma interface
#endif

template <class P>
class IA_BasePSIter {
  protected:
    // This is the point set we are iterating over.  Each derived class
    // will have a function to return this pointer casted to the
    // appropriate type derived from IA_BasePS

    IA_BasePS<P>	*domain;

public:
    // This constructor is required.  It sets the domain appropriately
    // so that derived classes don\'t have to worry about it.  It also
    // handles reference counting of the BasePS for compatibility with
    // the PointSet refcounting.
    IA_BasePSIter(IA_BasePS<P> *x);
    IA_BasePSIter(const IA_BasePSIter<P> & psi);
    // If an ojbect of a derived class is destructed through a base pointer
    // the correct destructor will be called.
    virtual ~IA_BasePSIter() { hash_managed_delete(domain); }

    IA_BasePSIter<P>& operator=(const IA_BasePSIter<P> &arg);

    // This returns a pointer to a copy of the object allocated on the heap
    virtual IA_BasePSIter<P> * clone_self() =0;

    /*
      If the iterator has reached the end, the next() method will return 0.
      Otherwise it will set the reference parameter to the
      (lexicographically) next point in the point set and return 1.
      */
    virtual int next(P&) =0;

    /* this method resets the iterator to the beginning of the point set */
    virtual void reset() =0;

    IA_BasePS<P> *domain_() const { return this->domain; }
};

#include "IntPoint.h"


#endif // BasePSIter_h_
