// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: BasePSIter.c,v $
// Revision 1.4  1994/08/18  23:39:28  thoth
// DOS-inspired filename rework
//
// Revision 1.3  1994/07/25  16:58:52  thoth
// \Name sanitization
//
// Revision 1.2  1994/03/30  13:45:29  thoth
// Renamed files to BasePSIter.
// Destructor for BasePSIter<IntPoint> needs to use the hash table.
//
// Revision 1.1  1993/09/15  12:38:15  thoth
// Initial revision
//

#include "BasePSIter.h"
#include "IntPS.h"
#include "HashTable.h"

template <class P>
IA_BasePSIter<P>::IA_BasePSIter(IA_BasePS<P> *x)
     :domain(x)
{
  domain->enref();
}

template <class P>
IA_BasePSIter<P>:: IA_BasePSIter(const IA_BasePSIter<P> & psi) {
  domain = psi.domain;
  domain->enref();
}

#if 0
IA_BasePSIter<IA_Point<int> >::~IA_BasePSIter() {
    if (domain->unref() <= 0) {
	IA_Set<IA_Point<int> >::hash_table.remove(domain);
	delete domain;
    }
}

template <class P>
IA_BasePSIter<P>:: ~IA_BasePSIter() {
    if (domain->unref() <= 0)
	delete domain;
}
#endif

template <class P>
IA_BasePSIter<P>& IA_BasePSIter<P>:: operator=(const IA_BasePSIter<P> &arg) {
    IA_BasePS<P>	*temp = arg.domain;
    temp->enref();
    hash_managed_delete(domain);
    domain = temp;
    return *this;
}
