// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

// 
// $Log: BasePS.c,v $
// Revision 1.12  1994/11/10  19:53:56  ljr
// Added IA_NO_RCS_STATIC_DATA guard.
//
// Revision 1.11  1994/11/10  19:25:55  fjsoria
// *** empty log message ***
//
// Revision 1.10  1994/10/06  17:39:00  fjsoria
// commented rscid[] line
//
// Revision 1.9  1993/08/08  13:10:32  thoth
// deInline some of the fallback virtual functions.
//
// Revision 1.8  93/05/28  16:13:56  thoth
// eliminate with-ia-pointset dependency.
// 
// Revision 1.7  93/05/26  16:40:45  thoth
// Copyright Notices.
// 
// Revision 1.6  92/12/16  14:47:53  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.5  92/12/07  12:05:05  thoth
// new IntPoint index(unsigned) operation for use with "other" iterators.
// 
// Revision 1.4  92/09/30  10:23:05  thoth
// BasePS is now templatized
// 
// Revision 1.3  92/09/03  13:31:45  thoth
// *** empty log message ***
// 
// Revision 1.2  92/08/26  13:41:53  thoth
// meaningful exception types
// 
// Revision 1.1  92/08/23  13:29:25  thoth
// Initial revision
// 
// 


#ifdef IA_PRII
#pragma implementation "BasePS.h"
#endif

#include "BasePS.h"
#include "LazyPS.h"

#include "pset_errors.h"

template <class P_t>
unsigned IA_BasePS<P_t>::index(const P_t&) const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
#if 0
    // we should put this var in class IA
    return PS_t::index_of_uncontained;
#else
    return ~0;
#endif
}

template <class P_t>
P_t IA_BasePS<P_t>::index(unsigned) const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
#if 0
    // we should put this var in class IA
    return PS_t::index_of_uncontained;
#else
    return ~0;
#endif
}


template <class P_t>
P_t IA_BasePS<P_t>:: min() const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
    return P_t();
}

template <class P_t>
P_t IA_BasePS<P_t>:: max() const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
    return P_t();
}

template <class P_t>
P_t IA_BasePS<P_t>:: inf() const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
    return P_t();
}

template <class P_t>
P_t IA_BasePS<P_t>:: sup() const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
    return P_t();
}

template <class P_t>
P_t IA_BasePS<P_t>:: choice() const {
    ia_throw(Pointset_RequireExtensive_Exception(__FILE__,__LINE__));
    return P_t();
}

template <class P_t>
IA_BasePS<P_t> *IA_BasePS<P_t>:: reflect_through_origin() const {
    return new IA_LazyOriginReflectionPS<P_t>(this);
}
