// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: placebo1.c,v $
// Revision 1.6.1.1  1994/12/28  18:09:19  thoth
// need pointset reflection.
// no longer need throw of enum.
//
// Revision 1.6  1994/09/19  18:12:34  thoth
// Placebo not needed for things provided by external library
//
// Revision 1.5  1994/03/15  14:24:06  thoth
// RGB image placebos.
//
// Revision 1.4  1994/03/14  15:53:50  thoth
// ValueSet has been replaced by container class Set.
//
// Revision 1.3  1993/12/29  17:30:55  thoth
// New Bit and unsigned Array stuff.
//
// Revision 1.2  1993/11/17  18:42:24  thoth
// placebos for Complex images and templates.
//
// Revision 1.1  1993/09/15  12:58:25  thoth
// Initial revision
//

#include <iostream.h>
#include <complex.h>

#include "Array.h"
#include "Point.h"
#include "Bit.h"
#include "RGB.h"

//
// Now we pacify the ptlink which doesn't know the meaning of -k
//

//complex operator/(complex lhs, complex) { return lhs; }
//ostream & operator<<(ostream &o, complex) { return o; }

// Array

#define ArrayStuff(T) \
	IA_Array<T>::IA_Array(T*,unsigned int,int) { } \
	IA_Array<T>& IA_Array<T>::operator=(const IA_Array<T>&) { return *this; } \
	IA_Array<T>::IA_Array(unsigned int) { }

IA_Array<unsigned>::IA_Array(const IA_Array<unsigned>&) { }
unsigned &IA_Array<unsigned>::operator[](unsigned idx) { return idx; }

ArrayStuff(complex)
ArrayStuff(double)
ArrayStuff(float)
ArrayStuff(unsigned)
ArrayStuff(int)
ArrayStuff(unsigned char)
ArrayStuff(IA_Bit)
ArrayStuff(IA_RGB)
    
//IA_Array<unsigned char>::IA_Array(unsigned char*,unsigned int,int) { }

#define PointStuff(T) \
	IA_Point<T>::IA_Point(const IA_Point<T>&) { } \
	ostream& operator<<(ostream&o,const IA_Point<T>&) { return o; } \
	IA_Point<T> IA_Point<T>::operator-() const { return *this; } \
	IA_Point<T> IA_Point<T>::operator-(const IA_Point<T>&) const { return *this; } \
	IA_Point<T> IA_Point<T>::operator+(const IA_Point<T>&) const { return *this; } \
	IA_Point<T>& IA_Point<T>::operator=(const IA_Point<T>&) { return *this; } \
	IA_Point<T> IA_Point<T>::operator+(T) const { return *this; }

PointStuff(double)
PointStuff(int)
IA_Point<double>::IA_Point(const IA_Point<int>&) { }


//void ia_throw(IA::Error,char*,int) { }



// IA_Array<unsigned char> IA_Array<unsigned char>::operator=(const IA_Array<unsigned char>&)
// unsigned char IA_Array<unsigned char>::IA_Array<unsigned char>(unsigned int)


//void IA_PSPred<IA_Point<int> >::output(ostream&o,unsigned int) const { return; }
//char IA_PSPred<IA_Point<int> >::type_;
