#!perl

#
#	Copyright 1993, Center for Computer Vision and Visualization,
#	University of Florida.  All rights reserved.
#

#
# $Log: build-from-stdin.perl,v $
# Revision 1.1  1994/05/17  12:49:29  thoth
# Initial revision
#

@filenames = <STDIN>;
foreach (@filenames) { chop; }

$arl = "";
while (@ARGV) {
    $_ = shift;
    if (/^-/) {
	$arl = $';
    } else {
	unshift(@ARGV, $_);
	last;
    }
}

($libname) = @ARGV;

@objnames = @filenames;
foreach (@objnames) {
    s/\.c$/.o/;
}

#print join("\n", @objnames);

$childpid = fork;
if ($childpid==0) {
    waitpid($childpid, 0);
} else {
    local($make) =  defined($ENV{MAKE}) ? $ENV{MAKE} : "make";
    exec  $make . " " . join(" ", reverse(@objnames));
    print  $make . " " . join(" ", @objnames);
    die "$0: Unable to exec make ($make)\n";
}

if ($? != 0) {
    die "$0: Child make failed.  Aborting\n";
}
