// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FuncI.c,v $

#include "LazyImage.h"

template < class P,class T>
char IA_LazyReflectionImage<P,T>::type_;

template <class P, class T>
IA_LazyReflectionImage<P,T>::IA_LazyReflectionImage(IA_BaseImage<P,T> *arg_)
    :IA_BaseImage<P,T>(-arg->domain())
{
    arg = arg_;
    arg->incr_ref();
}

template <class P, class T>
IA_LazyReflectionImage<P,T>::~IA_LazyReflectionImage()
{
    if (arg->decr_ref()<=0)
	delete arg;
}

template <class P, class T>
ostream& IA_LazyReflectionImage<P,T>::print_this(ostream&o) const {
    o<< "reflection of\n";
    return arg->print_this(o);
}
