//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: int-conv.desc,v $
// Revision 1.7  1994/02/24  18:25:47  thoth
// You can now convolve IntDDTemplates.
//
// Revision 1.6  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.5  1994/01/07  15:24:53  thoth
// Template reductions had wrong ring zeros.
//
// Revision 1.4  1993/11/17  18:41:07  thoth
// forward convolutions are now supported.
// template reductions are now supported.
//
// Revision 1.3  1993/09/27  15:54:56  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
//
// Revision 1.2  93/09/21  11:44:32  thoth
// remove cruft that belongs in double-convolutions.desc
// 
// Revision 1.1  93/09/15  13:04:31  thoth
// Initial revision
// 
// Revision 1.3  93/05/27  11:41:13  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// convolution linear_product T(int) T(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: templ-templ-product,v $
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/29  21:06:48  jnw
// Initial revision
//


#if 0

#include "LazyInvConv.h"

#else
#ifdef UNKNOWN_IA_lazy_linear_product_int

#error Uhoh, template-template convolutions must be declared before their image-template brothers

#endif

#ifndef KNOWN_IA_lazy_linear_product_int
#define KNOWN_IA_lazy_linear_product_int

struct IA_lazy_inv_linear_product_int : public IA_InvariantDT< IA_Image<IA_Point<int>,int> > {
  private:
    static char dummy;

public:
    /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> >	lhs, rhs;

public:
    IA_lazy_inv_linear_product_int(const IA_Set<IA_Point<int> > &ps,
		     const /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> > &lhs_,
		     const /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> > &rhs_)
	: IA_InvariantDT< IA_Image<IA_Point<int>,int> >(ps, linear_product(lhs_(extend_to_point(0,ps.dim())),
					    rhs_,
					    lhs_(extend_to_point(0,ps.dim())).domain() + rhs_(extend_to_point(0,ps.dim())).domain())),
    lhs(lhs_), rhs(rhs_) {
    }

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
    int is_a(IA::Type t) {
	 int rval;
	rval = (t == s_type());
	rval = rval || t == IA_InvariantDT< IA_Image<IA_Point<int>,int> >::s_type();
	return rval; }
};

char IA_lazy_inv_linear_product_int :: dummy;

#endif // KNOWN_IA_lazy_linear_product_int

#endif

/*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> >
linear_product(const IA_DDTemplate< IA_Image<IA_Point<int>,int> > &lhs_,
     const IA_DDTemplate< IA_Image<IA_Point<int>,int> > &rhs_)
{
    /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> > lhs(lhs_);
    /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> > rhs(rhs_);
    if (lhs.type() == IA_InvariantDT< IA_Image<IA_Point<int>,int> >::s_type() &&
	rhs.type() == IA_InvariantDT< IA_Image<IA_Point<int>,int> >::s_type()) {
#if 0
	return /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,int> >
	    (new IA_lazy_inv_linear_product_int (lhs.domain(), lhs, rhs ));
#else
	return IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::make_DT
	    (new IA_lazy_inv_linear_product_int (lhs.domain(), lhs, rhs ));
#endif
    } else {
	IA::not_yet_implemented(__FILE__, __LINE__);
    }
 
}


// convolution linear_product zero=0 I(int) I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: img-templ-product,v $
// Revision 1.11.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.11.1.2  1995/01/09  18:19:53  thoth
// Boxy pointset constructor replaced by function.
//
// Revision 1.11.1.1  1994/12/28  18:08:25  thoth
// boxy IPSet constructor is obsolete.
// detect dimension mismatch earlier.
//
// Revision 1.11  1994/12/22  16:31:05  fjsoria
// extra "," in linear product
//
// Revision 1.10  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.9  1994/03/30  14:01:44  thoth
// zero_extension is now a template function.
//
// Revision 1.8  1994/03/14  15:53:13  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.7  1994/02/22  18:49:39  thoth
// We now efficiently evaluate lazy template-template convolutions
// convolved with images.
//
// Revision 1.6  1994/02/12  19:45:43  thoth
// Forward and Backward convolutions are now specified separately.
//
// Revision 1.5  1994/01/31  15:50:18  thoth
// fixed typing error in invariant convolutions.
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:29:46  thoth
// We now have support for forward convolutions.
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  13:02:08  thoth
// Initial revision
//
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_Point<int> membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

//
// backward convolutions
//

static IA_Image<IA_Point<int>,int>
backw_linear_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a = 0; ;

	for (i=0; i<templ_sz; i++) {
	    a += (base[templ_offsets[i]]) * (templ_data[i]); ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_Image<IA_Point<int>,int>
backw_linear_product_inv(const IA_Image<IA_Point<int>,int> &img,
	 const IA_Image<IA_Point<int>,int> &invtempl,
	 IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_Point<int>	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(0));
    IA_Image<IA_Point<int>,int>	rval =
	backw_linear_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
linear_product(const IA_Image<IA_Point<int>,int> &img_,
     const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> >	templ(templ_);

#ifdef KNOWN_IA_lazy_linear_product_int
    if (templ.is_a(IA_lazy_inv_linear_product_int::s_type())) {
	const IA_lazy_inv_linear_product_int	*t =
	    (const IA_lazy_inv_linear_product_int *)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ);
	IA_Set<IA_Point<int> >	bigger_ps = IA_boxy_pset(
	    IA_Point<int>(dest_ps.inf()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().inf())),
	    IA_Point<int>(dest_ps.sup()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().sup()))
	    );
	return linear_product(linear_product(img, t->lhs, bigger_ps), t->rhs, dest_ps);
    } else
#else
#define UNKNOWN_IA_lazy_linear_product_int
#endif
	if (templ.is_a(IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type())) {
	return backw_linear_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
//    } else if (templ.type() == IA_Lazy_REDUCT_DT<IA_Image<IA_Point<int>,int> >::s_type()) {
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_PSIter<IA_Point<int> >	dest_iter(dest_ps);
	IA_Point<int>	base_ip;
	while (dest_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a = 0; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		a += img(ip) * templ_val; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
					   dest_ps.card(), 1);
    }
}

// convolution linear_product zero=0 I(int) T(int) I(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: templ-img-product,v $
// Revision 1.6.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.6.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/04/15  13:20:18  thoth
// zero_extend is now a function template.
//
// Revision 1.4  1994/03/30  14:02:11  thoth
// zero_extension is now a template function.
//
// Revision 1.3  1994/03/14  15:54:35  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.2  1994/02/24  18:26:06  thoth
// prepare for alterations in sed script that allow passing of base
// template container type instead of derived.
//
// Revision 1.1  1994/02/12  19:45:43  thoth
// Initial revision
//


//
// foward convolutions
//

static IA_Image<IA_Point<int>,int>
forw_linear_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = -ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan -= ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a = 0; ;

	for (i=0; i<templ_sz; i++) {
	    a += (base[templ_offsets[i]]) * (templ_data[i]); ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static
IA_Image<IA_Point<int>,int>
forw_linear_product_inv(const IA_Image<IA_Point<int>,int> &img,
	const IA_Image<IA_Point<int>,int> &invtempl,
	IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()-invtempl.domain().sup();
    IA_Point<int>	sup_ = dest_ps.sup()-invtempl.domain().inf();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(0));
    IA_Image<IA_Point<int>,int>	rval =
	forw_linear_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     const IA_Image<IA_Point<int>,int> &img_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ(templ_);

    if (templ.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	return forw_linear_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
    } else {
	unsigned	size = dest_ps.card();
	int *const	dest_data = new int[size];

	for (int i=0; i<size; i++) {
	    // _IRESULT_=dest_data[i]
	    // int	a = 0; ;
	    dest_data[i]=0;
	}

	IA_PSIter<IA_Point<int> >	src_iter(img.domain());
	IA_Point<int>	base_ip;
	while (src_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;
	    int	ival = img(base_ip);

	    // _IVAL_=ival
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! dest_ps.contains(templ_ip))
		    continue;
		unsigned	offset = dest_ps.index(templ_ip);
		int	*valp = dest_data + offset;
//		cout << "templ(" << base_ip << ") =  " << tv << " and templ()("
//		     << templ_ip <<") = " << templ_val << endl;
		(*valp) += ival * templ_val; ;
	    }
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
						      size, 1);
    }
}

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
// convolution addmax_product zero=-MAXINT I(int) I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: img-templ-product,v $
// Revision 1.11.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.11.1.2  1995/01/09  18:19:53  thoth
// Boxy pointset constructor replaced by function.
//
// Revision 1.11.1.1  1994/12/28  18:08:25  thoth
// boxy IPSet constructor is obsolete.
// detect dimension mismatch earlier.
//
// Revision 1.11  1994/12/22  16:31:05  fjsoria
// extra "," in linear product
//
// Revision 1.10  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.9  1994/03/30  14:01:44  thoth
// zero_extension is now a template function.
//
// Revision 1.8  1994/03/14  15:53:13  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.7  1994/02/22  18:49:39  thoth
// We now efficiently evaluate lazy template-template convolutions
// convolved with images.
//
// Revision 1.6  1994/02/12  19:45:43  thoth
// Forward and Backward convolutions are now specified separately.
//
// Revision 1.5  1994/01/31  15:50:18  thoth
// fixed typing error in invariant convolutions.
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:29:46  thoth
// We now have support for forward convolutions.
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  13:02:08  thoth
// Initial revision
//
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_Point<int> membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

//
// backward convolutions
//

static IA_Image<IA_Point<int>,int>
backw_addmax_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=-MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int ival = (base[templ_offsets[i]]); if (ival == -MAXINT) continue; int temp = (base[templ_offsets[i]])+(templ_data[i]); if (temp > a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_Image<IA_Point<int>,int>
backw_addmax_product_inv(const IA_Image<IA_Point<int>,int> &img,
	 const IA_Image<IA_Point<int>,int> &invtempl,
	 IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_Point<int>	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(-MAXINT));
    IA_Image<IA_Point<int>,int>	rval =
	backw_addmax_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
addmax_product(const IA_Image<IA_Point<int>,int> &img_,
     const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> >	templ(templ_);

#ifdef KNOWN_IA_lazy_addmax_product_int
    if (templ.is_a(IA_lazy_inv_addmax_product_int::s_type())) {
	const IA_lazy_inv_addmax_product_int	*t =
	    (const IA_lazy_inv_addmax_product_int *)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ);
	IA_Set<IA_Point<int> >	bigger_ps = IA_boxy_pset(
	    IA_Point<int>(dest_ps.inf()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().inf())),
	    IA_Point<int>(dest_ps.sup()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().sup()))
	    );
	return addmax_product(addmax_product(img, t->lhs, bigger_ps), t->rhs, dest_ps);
    } else
#else
#define UNKNOWN_IA_lazy_addmax_product_int
#endif
	if (templ.is_a(IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type())) {
	return backw_addmax_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
//    } else if (templ.type() == IA_Lazy_REDUCT_DT<IA_Image<IA_Point<int>,int> >::s_type()) {
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_PSIter<IA_Point<int> >	dest_iter(dest_ps);
	IA_Point<int>	base_ip;
	while (dest_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a=-MAXINT; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		register int ival = img(ip); if (ival == -MAXINT) continue; int temp = img(ip)+templ_val; if (temp > a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
					   dest_ps.card(), 1);
    }
}

// convolution addmax_product zero=-MAXINT I(int) T(int) I(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: templ-img-product,v $
// Revision 1.6.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.6.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/04/15  13:20:18  thoth
// zero_extend is now a function template.
//
// Revision 1.4  1994/03/30  14:02:11  thoth
// zero_extension is now a template function.
//
// Revision 1.3  1994/03/14  15:54:35  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.2  1994/02/24  18:26:06  thoth
// prepare for alterations in sed script that allow passing of base
// template container type instead of derived.
//
// Revision 1.1  1994/02/12  19:45:43  thoth
// Initial revision
//


//
// foward convolutions
//

static IA_Image<IA_Point<int>,int>
forw_addmax_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = -ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan -= ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=-MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int ival = (base[templ_offsets[i]]); if (ival == -MAXINT) continue; int temp = (base[templ_offsets[i]])+(templ_data[i]); if (temp > a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static
IA_Image<IA_Point<int>,int>
forw_addmax_product_inv(const IA_Image<IA_Point<int>,int> &img,
	const IA_Image<IA_Point<int>,int> &invtempl,
	IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()-invtempl.domain().sup();
    IA_Point<int>	sup_ = dest_ps.sup()-invtempl.domain().inf();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(-MAXINT));
    IA_Image<IA_Point<int>,int>	rval =
	forw_addmax_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     const IA_Image<IA_Point<int>,int> &img_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ(templ_);

    if (templ.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	return forw_addmax_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
    } else {
	unsigned	size = dest_ps.card();
	int *const	dest_data = new int[size];

	for (int i=0; i<size; i++) {
	    // _IRESULT_=dest_data[i]
	    // int	a=-MAXINT; ;
	    dest_data[i]=-MAXINT;
	}

	IA_PSIter<IA_Point<int> >	src_iter(img.domain());
	IA_Point<int>	base_ip;
	while (src_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;
	    int	ival = img(base_ip);

	    // _IVAL_=ival
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! dest_ps.contains(templ_ip))
		    continue;
		unsigned	offset = dest_ps.index(templ_ip);
		int	*valp = dest_data + offset;
//		cout << "templ(" << base_ip << ") =  " << tv << " and templ()("
//		     << templ_ip <<") = " << templ_val << endl;
		int temp = ival + templ_val; if (temp > (*valp)) (*valp) = temp; ;
	    }
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
						      size, 1);
    }
}

//
// convolution addmin_product zero=MAXINT I(int) I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: img-templ-product,v $
// Revision 1.11.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.11.1.2  1995/01/09  18:19:53  thoth
// Boxy pointset constructor replaced by function.
//
// Revision 1.11.1.1  1994/12/28  18:08:25  thoth
// boxy IPSet constructor is obsolete.
// detect dimension mismatch earlier.
//
// Revision 1.11  1994/12/22  16:31:05  fjsoria
// extra "," in linear product
//
// Revision 1.10  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.9  1994/03/30  14:01:44  thoth
// zero_extension is now a template function.
//
// Revision 1.8  1994/03/14  15:53:13  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.7  1994/02/22  18:49:39  thoth
// We now efficiently evaluate lazy template-template convolutions
// convolved with images.
//
// Revision 1.6  1994/02/12  19:45:43  thoth
// Forward and Backward convolutions are now specified separately.
//
// Revision 1.5  1994/01/31  15:50:18  thoth
// fixed typing error in invariant convolutions.
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:29:46  thoth
// We now have support for forward convolutions.
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  13:02:08  thoth
// Initial revision
//
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_Point<int> membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

//
// backward convolutions
//

static IA_Image<IA_Point<int>,int>
backw_addmin_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int ival = (base[templ_offsets[i]]); if (ival == MAXINT) continue; int temp = ival+(templ_data[i]); if (temp < a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_Image<IA_Point<int>,int>
backw_addmin_product_inv(const IA_Image<IA_Point<int>,int> &img,
	 const IA_Image<IA_Point<int>,int> &invtempl,
	 IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_Point<int>	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(MAXINT));
    IA_Image<IA_Point<int>,int>	rval =
	backw_addmin_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
addmin_product(const IA_Image<IA_Point<int>,int> &img_,
     const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> >	templ(templ_);

#ifdef KNOWN_IA_lazy_addmin_product_int
    if (templ.is_a(IA_lazy_inv_addmin_product_int::s_type())) {
	const IA_lazy_inv_addmin_product_int	*t =
	    (const IA_lazy_inv_addmin_product_int *)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ);
	IA_Set<IA_Point<int> >	bigger_ps = IA_boxy_pset(
	    IA_Point<int>(dest_ps.inf()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().inf())),
	    IA_Point<int>(dest_ps.sup()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().sup()))
	    );
	return addmin_product(addmin_product(img, t->lhs, bigger_ps), t->rhs, dest_ps);
    } else
#else
#define UNKNOWN_IA_lazy_addmin_product_int
#endif
	if (templ.is_a(IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type())) {
	return backw_addmin_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
//    } else if (templ.type() == IA_Lazy_REDUCT_DT<IA_Image<IA_Point<int>,int> >::s_type()) {
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_PSIter<IA_Point<int> >	dest_iter(dest_ps);
	IA_Point<int>	base_ip;
	while (dest_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a=MAXINT; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		int temp = img(ip)+templ_val; if (temp < a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
					   dest_ps.card(), 1);
    }
}

// convolution addmin_product zero=MAXINT I(int) T(int) I(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: templ-img-product,v $
// Revision 1.6.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.6.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/04/15  13:20:18  thoth
// zero_extend is now a function template.
//
// Revision 1.4  1994/03/30  14:02:11  thoth
// zero_extension is now a template function.
//
// Revision 1.3  1994/03/14  15:54:35  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.2  1994/02/24  18:26:06  thoth
// prepare for alterations in sed script that allow passing of base
// template container type instead of derived.
//
// Revision 1.1  1994/02/12  19:45:43  thoth
// Initial revision
//


//
// foward convolutions
//

static IA_Image<IA_Point<int>,int>
forw_addmin_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = -ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan -= ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int ival = (base[templ_offsets[i]]); if (ival == MAXINT) continue; int temp = ival+(templ_data[i]); if (temp < a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static
IA_Image<IA_Point<int>,int>
forw_addmin_product_inv(const IA_Image<IA_Point<int>,int> &img,
	const IA_Image<IA_Point<int>,int> &invtempl,
	IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()-invtempl.domain().sup();
    IA_Point<int>	sup_ = dest_ps.sup()-invtempl.domain().inf();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(MAXINT));
    IA_Image<IA_Point<int>,int>	rval =
	forw_addmin_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     const IA_Image<IA_Point<int>,int> &img_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ(templ_);

    if (templ.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	return forw_addmin_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
    } else {
	unsigned	size = dest_ps.card();
	int *const	dest_data = new int[size];

	for (int i=0; i<size; i++) {
	    // _IRESULT_=dest_data[i]
	    // int	a=MAXINT; ;
	    dest_data[i]=MAXINT;
	}

	IA_PSIter<IA_Point<int> >	src_iter(img.domain());
	IA_Point<int>	base_ip;
	while (src_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;
	    int	ival = img(base_ip);

	    // _IVAL_=ival
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! dest_ps.contains(templ_ip))
		    continue;
		unsigned	offset = dest_ps.index(templ_ip);
		int	*valp = dest_data + offset;
//		cout << "templ(" << base_ip << ") =  " << tv << " and templ()("
//		     << templ_ip <<") = " << templ_val << endl;
		int temp = ival + templ_val; if (temp < (*valp)) (*valp) = temp; ;
	    }
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
						      size, 1);
    }
}

//
// convolution multmax_product zero=-1 I(int) I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: img-templ-product,v $
// Revision 1.11.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.11.1.2  1995/01/09  18:19:53  thoth
// Boxy pointset constructor replaced by function.
//
// Revision 1.11.1.1  1994/12/28  18:08:25  thoth
// boxy IPSet constructor is obsolete.
// detect dimension mismatch earlier.
//
// Revision 1.11  1994/12/22  16:31:05  fjsoria
// extra "," in linear product
//
// Revision 1.10  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.9  1994/03/30  14:01:44  thoth
// zero_extension is now a template function.
//
// Revision 1.8  1994/03/14  15:53:13  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.7  1994/02/22  18:49:39  thoth
// We now efficiently evaluate lazy template-template convolutions
// convolved with images.
//
// Revision 1.6  1994/02/12  19:45:43  thoth
// Forward and Backward convolutions are now specified separately.
//
// Revision 1.5  1994/01/31  15:50:18  thoth
// fixed typing error in invariant convolutions.
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:29:46  thoth
// We now have support for forward convolutions.
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  13:02:08  thoth
// Initial revision
//
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_Point<int> membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

//
// backward convolutions
//

static IA_Image<IA_Point<int>,int>
backw_multmax_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=-1; ;

	for (i=0; i<templ_sz; i++) {
	    register int	ival = (base[templ_offsets[i]]); if (ival<0) continue; int temp = ival*(templ_data[i]); if (temp>a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_Image<IA_Point<int>,int>
backw_multmax_product_inv(const IA_Image<IA_Point<int>,int> &img,
	 const IA_Image<IA_Point<int>,int> &invtempl,
	 IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_Point<int>	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(-1));
    IA_Image<IA_Point<int>,int>	rval =
	backw_multmax_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
multmax_product(const IA_Image<IA_Point<int>,int> &img_,
     const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> >	templ(templ_);

#ifdef KNOWN_IA_lazy_multmax_product_int
    if (templ.is_a(IA_lazy_inv_multmax_product_int::s_type())) {
	const IA_lazy_inv_multmax_product_int	*t =
	    (const IA_lazy_inv_multmax_product_int *)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ);
	IA_Set<IA_Point<int> >	bigger_ps = IA_boxy_pset(
	    IA_Point<int>(dest_ps.inf()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().inf())),
	    IA_Point<int>(dest_ps.sup()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().sup()))
	    );
	return multmax_product(multmax_product(img, t->lhs, bigger_ps), t->rhs, dest_ps);
    } else
#else
#define UNKNOWN_IA_lazy_multmax_product_int
#endif
	if (templ.is_a(IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type())) {
	return backw_multmax_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
//    } else if (templ.type() == IA_Lazy_REDUCT_DT<IA_Image<IA_Point<int>,int> >::s_type()) {
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_PSIter<IA_Point<int> >	dest_iter(dest_ps);
	IA_Point<int>	base_ip;
	while (dest_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a=-1; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		int temp = img(ip)*templ_val; if (temp>a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
					   dest_ps.card(), 1);
    }
}

// convolution multmax_product zero=-1 I(int) T(int) I(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: templ-img-product,v $
// Revision 1.6.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.6.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/04/15  13:20:18  thoth
// zero_extend is now a function template.
//
// Revision 1.4  1994/03/30  14:02:11  thoth
// zero_extension is now a template function.
//
// Revision 1.3  1994/03/14  15:54:35  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.2  1994/02/24  18:26:06  thoth
// prepare for alterations in sed script that allow passing of base
// template container type instead of derived.
//
// Revision 1.1  1994/02/12  19:45:43  thoth
// Initial revision
//


//
// foward convolutions
//

static IA_Image<IA_Point<int>,int>
forw_multmax_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = -ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan -= ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=-1; ;

	for (i=0; i<templ_sz; i++) {
	    register int	ival = (base[templ_offsets[i]]); if (ival<0) continue; int temp = ival*(templ_data[i]); if (temp>a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static
IA_Image<IA_Point<int>,int>
forw_multmax_product_inv(const IA_Image<IA_Point<int>,int> &img,
	const IA_Image<IA_Point<int>,int> &invtempl,
	IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()-invtempl.domain().sup();
    IA_Point<int>	sup_ = dest_ps.sup()-invtempl.domain().inf();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(-1));
    IA_Image<IA_Point<int>,int>	rval =
	forw_multmax_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     const IA_Image<IA_Point<int>,int> &img_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ(templ_);

    if (templ.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	return forw_multmax_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
    } else {
	unsigned	size = dest_ps.card();
	int *const	dest_data = new int[size];

	for (int i=0; i<size; i++) {
	    // _IRESULT_=dest_data[i]
	    // int	a=-1; ;
	    dest_data[i]=-1;
	}

	IA_PSIter<IA_Point<int> >	src_iter(img.domain());
	IA_Point<int>	base_ip;
	while (src_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;
	    int	ival = img(base_ip);

	    // _IVAL_=ival
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! dest_ps.contains(templ_ip))
		    continue;
		unsigned	offset = dest_ps.index(templ_ip);
		int	*valp = dest_data + offset;
//		cout << "templ(" << base_ip << ") =  " << tv << " and templ()("
//		     << templ_ip <<") = " << templ_val << endl;
		int temp = ival * templ_val; if (temp > (*valp)) (*valp) = temp; ;
	    }
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
						      size, 1);
    }
}

//
// convolution multmin_product zero=-1 I(int) I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: img-templ-product,v $
// Revision 1.11.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.11.1.2  1995/01/09  18:19:53  thoth
// Boxy pointset constructor replaced by function.
//
// Revision 1.11.1.1  1994/12/28  18:08:25  thoth
// boxy IPSet constructor is obsolete.
// detect dimension mismatch earlier.
//
// Revision 1.11  1994/12/22  16:31:05  fjsoria
// extra "," in linear product
//
// Revision 1.10  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.9  1994/03/30  14:01:44  thoth
// zero_extension is now a template function.
//
// Revision 1.8  1994/03/14  15:53:13  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.7  1994/02/22  18:49:39  thoth
// We now efficiently evaluate lazy template-template convolutions
// convolved with images.
//
// Revision 1.6  1994/02/12  19:45:43  thoth
// Forward and Backward convolutions are now specified separately.
//
// Revision 1.5  1994/01/31  15:50:18  thoth
// fixed typing error in invariant convolutions.
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:29:46  thoth
// We now have support for forward convolutions.
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  13:02:08  thoth
// Initial revision
//
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_Point<int> membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

//
// backward convolutions
//

static IA_Image<IA_Point<int>,int>
backw_multmin_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int	ival = (base[templ_offsets[i]]); if (ival<0) continue; int temp = ival*(templ_data[i]); if (temp<a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_Image<IA_Point<int>,int>
backw_multmin_product_inv(const IA_Image<IA_Point<int>,int> &img,
	 const IA_Image<IA_Point<int>,int> &invtempl,
	 IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_Point<int>	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(-1));
    IA_Image<IA_Point<int>,int>	rval =
	backw_multmin_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
multmin_product(const IA_Image<IA_Point<int>,int> &img_,
     const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> >	templ(templ_);

#ifdef KNOWN_IA_lazy_multmin_product_int
    if (templ.is_a(IA_lazy_inv_multmin_product_int::s_type())) {
	const IA_lazy_inv_multmin_product_int	*t =
	    (const IA_lazy_inv_multmin_product_int *)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ);
	IA_Set<IA_Point<int> >	bigger_ps = IA_boxy_pset(
	    IA_Point<int>(dest_ps.inf()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().inf())),
	    IA_Point<int>(dest_ps.sup()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().sup()))
	    );
	return multmin_product(multmin_product(img, t->lhs, bigger_ps), t->rhs, dest_ps);
    } else
#else
#define UNKNOWN_IA_lazy_multmin_product_int
#endif
	if (templ.is_a(IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type())) {
	return backw_multmin_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
//    } else if (templ.type() == IA_Lazy_REDUCT_DT<IA_Image<IA_Point<int>,int> >::s_type()) {
    } else {
	int *const	dest_data = new int[dest_ps.card()];
	int	*valp = dest_data;
	IA_PSIter<IA_Point<int> >	dest_iter(dest_ps);
	IA_Point<int>	base_ip;
	while (dest_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    int	a=MAXINT; ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		int temp = img(ip)*templ_val; if (temp<a) a = temp; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
					   dest_ps.card(), 1);
    }
}

// convolution multmin_product zero=-1 I(int) T(int) I(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: templ-img-product,v $
// Revision 1.6.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.6.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/04/15  13:20:18  thoth
// zero_extend is now a function template.
//
// Revision 1.4  1994/03/30  14:02:11  thoth
// zero_extension is now a template function.
//
// Revision 1.3  1994/03/14  15:54:35  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.2  1994/02/24  18:26:06  thoth
// prepare for alterations in sed script that allow passing of base
// template container type instead of derived.
//
// Revision 1.1  1994/02/12  19:45:43  thoth
// Initial revision
//


//
// foward convolutions
//

static IA_Image<IA_Point<int>,int>
forw_multmin_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const int *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,int> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    int	*const templ_data = new int[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	int	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,int>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = -ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan -= ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    int *const	dest_data = new int[dest_ps.card()];
    int *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const int *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	int	a=MAXINT; ;

	for (i=0; i<templ_sz; i++) {
	    register int	ival = (base[templ_offsets[i]]); if (ival<0) continue; int temp = ival*(templ_data[i]); if (temp<a) a = temp; ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,int>(dest_ps, dest_data, dest_ps.card(), 1);
}

static
IA_Image<IA_Point<int>,int>
forw_multmin_product_inv(const IA_Image<IA_Point<int>,int> &img,
	const IA_Image<IA_Point<int>,int> &invtempl,
	IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,int>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()-invtempl.domain().sup();
    IA_Point<int>	sup_ = dest_ps.sup()-invtempl.domain().inf();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    int	*const src_data = new int[src_ps.card()];

    zero_extend(img, src_ps, (int*)src_data, int(-1));
    IA_Image<IA_Point<int>,int>	rval =
	forw_multmin_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,int>
multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ_,
     const IA_Image<IA_Point<int>,int> &img_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,int>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ(templ_);

    if (templ.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	return forw_multmin_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,int> >*)IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(templ))->value, dest_ps);
    } else {
	unsigned	size = dest_ps.card();
	int *const	dest_data = new int[size];

	for (int i=0; i<size; i++) {
	    // _IRESULT_=dest_data[i]
	    // int	a=MAXINT; ;
	    dest_data[i]=-1;
	}

	IA_PSIter<IA_Point<int> >	src_iter(img.domain());
	IA_Point<int>	base_ip;
	while (src_iter(base_ip)) {
	    IA_Image<IA_Point<int>,int>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,int>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    int	templ_val;
	    int	ival = img(base_ip);

	    // _IVAL_=ival
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! dest_ps.contains(templ_ip))
		    continue;
		unsigned	offset = dest_ps.index(templ_ip);
		int	*valp = dest_data + offset;
//		cout << "templ(" << base_ip << ") =  " << tv << " and templ()("
//		     << templ_ip <<") = " << templ_val << endl;
		if (ival ==-1) continue; int temp = ival * templ_val; if (temp < (*valp)) (*valp) = temp; ;
	    }
	}
	return IA_Image<IA_Point<int>,int>(dest_ps, dest_data,
						      size, 1);
    }
}

//
//
// reduction sum zero=0 I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: template-reduction,v $
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/02/12  19:46:56  thoth
// *** empty log message ***
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:45:07  thoth
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/10/20  18:32:02  thoth
// Initial revision
//

IA_Image<IA_Point<int>, int>
sum(IA_Set<IA_Point<int> > domain,
       IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ,
       IA_Set<IA_Point<int> > dest_domain)
{
    IA_Image<IA_Point<int>, int>	rval(dest_domain, (int)0);

    IA_PSIter<IA_Point<int> >	psiter(domain);
    IA_Point<int>	scan;

    while (psiter(scan)) {
	IA_Image<IA_Point<int>,int>	curr = templ(scan);
	IA_IPIter<IA_Point<int>, int>	iiter(curr);
	IA_Point<int>	p;
	int	val;
	// _IRESULT_=rval[p]
	// _TVAL_=val

	while (iiter(p,val)) {
	    if (rval.domain().contains(p)) {
		rval[p] += val; ;
	    }
	}
    }
    return rval;
}

// end reduction
// reduction max zero=-MAXINT I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: template-reduction,v $
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/02/12  19:46:56  thoth
// *** empty log message ***
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:45:07  thoth
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/10/20  18:32:02  thoth
// Initial revision
//

IA_Image<IA_Point<int>, int>
max(IA_Set<IA_Point<int> > domain,
       IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ,
       IA_Set<IA_Point<int> > dest_domain)
{
    IA_Image<IA_Point<int>, int>	rval(dest_domain, (int)-MAXINT);

    IA_PSIter<IA_Point<int> >	psiter(domain);
    IA_Point<int>	scan;

    while (psiter(scan)) {
	IA_Image<IA_Point<int>,int>	curr = templ(scan);
	IA_IPIter<IA_Point<int>, int>	iiter(curr);
	IA_Point<int>	p;
	int	val;
	// _IRESULT_=rval[p]
	// _TVAL_=val

	while (iiter(p,val)) {
	    if (rval.domain().contains(p)) {
		if (val>rval[p]) rval[p] = val; ;
	    }
	}
    }
    return rval;
}

// end reduction
// reduction min zero=MAXINT I(int) T(int)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: template-reduction,v $
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/02/12  19:46:56  thoth
// *** empty log message ***
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:45:07  thoth
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/10/20  18:32:02  thoth
// Initial revision
//

IA_Image<IA_Point<int>, int>
min(IA_Set<IA_Point<int> > domain,
       IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ,
       IA_Set<IA_Point<int> > dest_domain)
{
    IA_Image<IA_Point<int>, int>	rval(dest_domain, (int)MAXINT);

    IA_PSIter<IA_Point<int> >	psiter(domain);
    IA_Point<int>	scan;

    while (psiter(scan)) {
	IA_Image<IA_Point<int>,int>	curr = templ(scan);
	IA_IPIter<IA_Point<int>, int>	iiter(curr);
	IA_Point<int>	p;
	int	val;
	// _IRESULT_=rval[p]
	// _TVAL_=val

	while (iiter(p,val)) {
	    if (rval.domain().contains(p)) {
		if (val<rval[p]) rval[p] = val; ;
	    }
	}
    }
    return rval;
}

// end reduction
// binary operator+ zero=0 gamma=sum T(int) T(int) T(int)
// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: bin-TO,v $
// Revision 1.3  1994/09/16  14:57:11  thoth
// more DOS-inspired renaming.
//
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/29  21:08:26  jnw
// Initial revision
//

#include "DDTempl.h"
#include "InvDT.h"
#include "ImageIter.h"

void operatorIAOPpl_extending
(const IA_SetStructure &ss, int ** dst,
#ifdef FUNKY_ERROR
 void *src1_,
 void *src2_
#else
 IA_IVIter<IA_Point<int>,int> *src1,
 IA_IVIter<IA_Point<int>,int> *src2
#endif
)
{
#ifdef FUNKY_ERROR
    IA_IVIter<IA_Point<int>,int> *src1 =
	(IA_IVIter<IA_Point<int>,int> *)src1_;
    IA_IVIter<IA_Point<int>,int> *src2 =
	(IA_IVIter<IA_Point<int>,int> *)src2_;
#endif

    int	t1;
    int	t2;

    for(int i = 0; i < ss.nintervals(); i++) {
	IA_ss_interval ssi = ss.retrieve_interval(i);
	if (ssi.substructure == IA_SetStructure::BOTH) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src1)(t1))
		    IA::internal_error(__FILE__,__LINE__);
		if (!(*src2)(t2))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = t1 + t2;
	    }
	} else if (ssi.substructure == IA_SetStructure::FIRST_ONLY) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src1)(t1))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = t1 + (0);
	    }
	} else if (ssi.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src2)(t2))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = (0) + t2;
	    }
	} else {
	    for (int j=0; j<ssi.count; j++) {
		operatorIAOPpl_extending(ssi.substructure, dst, src1, src2);
	    }
	}
    }
}


IA_DDTemplate<IA_Image<IA_Point<int>,int> >
operator+(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &lhs,
   const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &rhs)
{
    if (lhs.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type() &&
	rhs.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	IA_SetStructure	ss;
	IA_Image<IA_Point<int>, int>	li=
	    ((IA_InvariantDT<IA_Image<IA_Point<int>, int> > *)
	     IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(lhs))->value;
	IA_Image<IA_Point<int>, int>	ri=
	    ((IA_InvariantDT<IA_Image<IA_Point<int>, int> > *)
	     IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(rhs))->value;
	IA_Set<IA_Point<int> >	ps = union_with_structure(li.domain(),
						  ri.domain(), &ss);
	const int sz = ps.card();
	int *const dest	= new int[sz];
	{
	    IA_IVIter<IA_Point<int>, int>	liter(li);
	    IA_IVIter<IA_Point<int>, int>	riter(ri);
	    int	*dp = dest;
	    operatorIAOPpl_extending(ss, &dp, &liter, &riter);
	}
	return IA_DDTemplate<IA_Image<IA_Point<int>,int> >
	    (lhs.domain(), IA_Image<IA_Point<int>, int>(ps, dest, sz, 1));
    } else {
	IA::not_yet_implemented(__FILE__, __LINE__);
    }
}
// binary min zero=MAXINT gamma=min T(int) T(int) T(int)
// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: bin-TF,v $
// Revision 1.3  1994/09/16  14:57:11  thoth
// more DOS-inspired renaming.
//
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/29  21:08:26  jnw
// Initial revision
//

#include "DDTempl.h"
#include "InvDT.h"
#include "ImageIter.h"

void min_extending
(const IA_SetStructure &ss, int ** dst,
#ifdef FUNKY_ERROR
 void *src1_,
 void *src2_
#else
 IA_IVIter<IA_Point<int>,int> *src1,
 IA_IVIter<IA_Point<int>,int> *src2
#endif
)
{
#ifdef FUNKY_ERROR
    IA_IVIter<IA_Point<int>,int> *src1 =
	(IA_IVIter<IA_Point<int>,int> *)src1_;
    IA_IVIter<IA_Point<int>,int> *src2 =
	(IA_IVIter<IA_Point<int>,int> *)src2_;
#endif

    int	t1;
    int	t2;

    for(int i = 0; i < ss.nintervals(); i++) {
	IA_ss_interval ssi = ss.retrieve_interval(i);
	if (ssi.substructure == IA_SetStructure::BOTH) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src1)(t1))
		    IA::internal_error(__FILE__,__LINE__);
		if (!(*src2)(t2))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = min( t1 , t2);
	    }
	} else if (ssi.substructure == IA_SetStructure::FIRST_ONLY) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src1)(t1))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = min( t1 , (MAXINT));
	    }
	} else if (ssi.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src2)(t2))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = min( (MAXINT) , t2);
	    }
	} else {
	    for (int j=0; j<ssi.count; j++) {
		min_extending(ssi.substructure, dst, src1, src2);
	    }
	}
    }
}


IA_DDTemplate<IA_Image<IA_Point<int>,int> >
min(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &lhs,
   const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &rhs)
{
    if (lhs.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type() &&
	rhs.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	IA_SetStructure	ss;
	IA_Image<IA_Point<int>, int>	li=
	    ((IA_InvariantDT<IA_Image<IA_Point<int>, int> > *)
	     IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(lhs))->value;
	IA_Image<IA_Point<int>, int>	ri=
	    ((IA_InvariantDT<IA_Image<IA_Point<int>, int> > *)
	     IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(rhs))->value;
	IA_Set<IA_Point<int> >	ps = union_with_structure(li.domain(),
						  ri.domain(), &ss);
	const int sz = ps.card();
	int *const dest	= new int[sz];
	{
	    IA_IVIter<IA_Point<int>, int>	liter(li);
	    IA_IVIter<IA_Point<int>, int>	riter(ri);
	    int	*dp = dest;
	    min_extending(ss, &dp, &liter, &riter);
	}
	return IA_DDTemplate<IA_Image<IA_Point<int>,int> >
	    (lhs.domain(), IA_Image<IA_Point<int>, int>(ps, dest, sz, 1));
    } else {
	IA::not_yet_implemented(__FILE__, __LINE__);
    }
}
// binary max zero=-MAXINT gamma=max T(int) T(int) T(int)
// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: bin-TF,v $
// Revision 1.3  1994/09/16  14:57:11  thoth
// more DOS-inspired renaming.
//
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/29  21:08:26  jnw
// Initial revision
//

#include "DDTempl.h"
#include "InvDT.h"
#include "ImageIter.h"

void max_extending
(const IA_SetStructure &ss, int ** dst,
#ifdef FUNKY_ERROR
 void *src1_,
 void *src2_
#else
 IA_IVIter<IA_Point<int>,int> *src1,
 IA_IVIter<IA_Point<int>,int> *src2
#endif
)
{
#ifdef FUNKY_ERROR
    IA_IVIter<IA_Point<int>,int> *src1 =
	(IA_IVIter<IA_Point<int>,int> *)src1_;
    IA_IVIter<IA_Point<int>,int> *src2 =
	(IA_IVIter<IA_Point<int>,int> *)src2_;
#endif

    int	t1;
    int	t2;

    for(int i = 0; i < ss.nintervals(); i++) {
	IA_ss_interval ssi = ss.retrieve_interval(i);
	if (ssi.substructure == IA_SetStructure::BOTH) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src1)(t1))
		    IA::internal_error(__FILE__,__LINE__);
		if (!(*src2)(t2))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = max( t1 , t2);
	    }
	} else if (ssi.substructure == IA_SetStructure::FIRST_ONLY) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src1)(t1))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = max( t1 , (-MAXINT));
	    }
	} else if (ssi.substructure == IA_SetStructure::SECOND_ONLY) {
	    for (int j=0; j<ssi.count; j++) {
		if (!(*src2)(t2))
		    IA::internal_error(__FILE__,__LINE__);
		*((*dst)++) = max( (-MAXINT) , t2);
	    }
	} else {
	    for (int j=0; j<ssi.count; j++) {
		max_extending(ssi.substructure, dst, src1, src2);
	    }
	}
    }
}


IA_DDTemplate<IA_Image<IA_Point<int>,int> >
max(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &lhs,
   const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &rhs)
{
    if (lhs.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type() &&
	rhs.type() == IA_InvariantDT<IA_Image<IA_Point<int>,int> >::s_type()) {
	IA_SetStructure	ss;
	IA_Image<IA_Point<int>, int>	li=
	    ((IA_InvariantDT<IA_Image<IA_Point<int>, int> > *)
	     IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(lhs))->value;
	IA_Image<IA_Point<int>, int>	ri=
	    ((IA_InvariantDT<IA_Image<IA_Point<int>, int> > *)
	     IA_FBI<IA_Point<int>, IA_Point<int>, int, int, int>::extract_baseptr(rhs))->value;
	IA_Set<IA_Point<int> >	ps = union_with_structure(li.domain(),
						  ri.domain(), &ss);
	const int sz = ps.card();
	int *const dest	= new int[sz];
	{
	    IA_IVIter<IA_Point<int>, int>	liter(li);
	    IA_IVIter<IA_Point<int>, int>	riter(ri);
	    int	*dp = dest;
	    max_extending(ss, &dp, &liter, &riter);
	}
	return IA_DDTemplate<IA_Image<IA_Point<int>,int> >
	    (lhs.domain(), IA_Image<IA_Point<int>, int>(ps, dest, sz, 1));
    } else {
	IA::not_yet_implemented(__FILE__, __LINE__);
    }
}
// convolution linear_product zero=0 gamma=sum circle=product T(int) T(int) T(int)
