// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ImgComp.h,v $
// Revision 1.1.1.1  1995/01/13  19:58:04  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.1  1994/09/16  18:24:34  thoth
// Initial revision
//

#ifndef ImgComp_h_
#define ImgComp_h_

#include "Closure.h"
//#include "Image.h"
template <class P, class T> class IA_Image;

// value composition
template <class P, class Q, class R, class S, class T>
IA_Image<P,Q> compose(R (*)(S), const IA_Image<P,T> &, const Q*, const R*, const S*);

template <class P, class R, class S, class T>
inline IA_Image<P,R> compose(R (*f)(S), const IA_Image<P,T> &i, const R*, const S*) { return compose(f, i, (const R*)0, (const R*)0, (const S*)0); }

template <class P, class S, class T>
inline IA_Image<P,S> compose(S (*f)(T), const IA_Image<P,T> &i, const S*) { return compose(f, i, (const S*)0, (const S*)0, (const T*)0); }

template <class P, class T>
inline IA_Image<P,T> compose(T (*f)(T), const IA_Image<P,T> &i) { return compose(f, i, (const T*)0, (const T*)0, (const T*)0); }




template <class P, class Q, class R, class S, class T>
IA_Image<P,Q> compose(const IA_Closure<S,R>&, const IA_Image<P,T> &, const Q*);

template <class P, class R, class S, class T>
inline IA_Image<P,R> compose(const IA_Closure<S,R>&f, const IA_Image<P,T> &i) { return compose(f, i, (const R*)0); }

#endif // ImgComp_h_
