// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ImgComp.c,v $
// Revision 1.1.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.1.1.1  1995/01/09  18:07:11  thoth
// We use ImageIter, let's include its header.
//
// Revision 1.1  1994/09/16  18:24:34  thoth
// Initial revision
//

#include "ImgComp.h"
#include "ImageIter.h"

template <class P, class Q, class R, class S, class T>
IA_Image<P,Q> compose(R (*f)(S), const IA_Image<P,T> &i, const Q*, const R*, const S*)
{
    IA_IVIter<P,T>	iter(i);
    const int size = i.card();
    Q * const vals = new Q[size];

    {
	Q	*scan=vals;
	T	temp;
	while (iter(temp))
	    *(scan++) = f(temp);
    }

    return IA_Image<P,Q>(i.domain(), vals, size, 1);
}

template <class P, class Q, class R, class S, class T>
IA_Image<P,Q> compose(const IA_Closure<S,R>&f,
			  const IA_Image<P,T> &i,
			  const Q*)
{
    IA_IVIter<P,T>	iter(i);
    const int size = i.card();
    Q * const vals = new Q[size];

    {
	Q	*scan=vals;
	T	temp;
	while (iter(temp))
	    *(scan++) = f(temp);
    }

    return IA_Image<P,Q>(i.domain(), vals, size, 1);
}
