// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: int-operations.desc,v $
//  Revision 1.9.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.9.1.1  1994/12/28  17:56:27  thoth
//  Conversion to operations table.
//  image operations are now friendly with FBI.
//  new sgn() function.

//  Revision 1.9  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.8  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Integer operations for the Int Discrete Image
#include "IntDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
#include <values.h>
#define  const_reduce_int_int_sum
inline int const_reduce_sum(unsigned sz, int arg)
{
    return sz * arg;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction sum subop=operator+ zero=0 int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_int_int_sum
#define REDUCE_int_int_sum
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_sum_tbl;

void IA_fill_Image_IP_int_int_sum_tbl();
#endif // REDUCE_int_int_sum


int sum ( const IA_Image<IA_Point<int>, int> &arg)
{
    if (!IA_Image_IP_int_int_sum_tbl)
	IA_fill_Image_IP_int_int_sum_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_sum_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, int>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_int_sum
#define vec_reduce_int_int_sum
static int
vec_reduce_sum(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_VectorI<IA_Point<int>, int> *lhs =
	(IA_VectorI<IA_Point<int>, int> *) &lhs_;

    const int *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval + (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_int_int_sum

#ifndef scalar_reduce_int_int_sum
#define scalar_reduce_int_int_sum
static int
scalar_reduce_sum(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_ConstI<IA_Point<int>, int> *lhs =
	(IA_ConstI<IA_Point<int>, int> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval + lhs->value;

    return rval;
}
#endif // scalar_reduce_int_int_sum

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_int_sum
#define iter_reduce_int_int_sum
static int
iter_reduce_sum(IA_BaseImage<IA_Point<int>, int> &lhs)
{
    const unsigned sz = lhs.domain().card();

    int ltmp;
    IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval + ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_int_sum

#ifndef FILL_REDUCE_int_int_sum
#define FILL_REDUCE_int_int_sum
void IA_fill_Image_IP_int_int_sum_tbl()
{
    if (IA_Image_IP_int_int_sum_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_reduce_sum;

    IA_Image_IP_int_int_sum_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >(iter_reduce_sum);
    IA_Image_IP_int_int_sum_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_reduce_sum);
    IA_Image_IP_int_int_sum_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_reduce_sum);

}
#endif // REDUCE_int_int_sum

#if 0

static int vec_reduce_sum(const IA_VectorI<IA_Point<int>, int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_sum
#define const_reduce_int_int_sum
static int const_reduce_sum(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static int iter_reduce_sum(const IA_Image<IA_Point<int>, int> &arg)
{
    IA_IVIter<IA_Point<int>, int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

int sum ( const IA_Image<IA_Point<int>, int> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 0 );
    IA_Image<IA_Point<int>, int>	arg(arg_);

    IA_BaseImage<IA_Point<int>, int>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, int>::s_type()) {
	return vec_reduce_sum((IA_VectorI<IA_Point<int>, int> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, int>::s_type()) {
	return const_reduce_sum
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, int> *)bip)->value);
    } else {
	return iter_reduce_sum(arg);
    }
}

#endif

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction product zero=1 subop=operator* int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_int_int_product
#define REDUCE_int_int_product
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_product_tbl;

void IA_fill_Image_IP_int_int_product_tbl();
#endif // REDUCE_int_int_product


int product ( const IA_Image<IA_Point<int>, int> &arg)
{
    if (!IA_Image_IP_int_int_product_tbl)
	IA_fill_Image_IP_int_int_product_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_product_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, int>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_int_product
#define vec_reduce_int_int_product
static int
vec_reduce_product(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_VectorI<IA_Point<int>, int> *lhs =
	(IA_VectorI<IA_Point<int>, int> *) &lhs_;

    const int *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval * (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_int_int_product

#ifndef scalar_reduce_int_int_product
#define scalar_reduce_int_int_product
static int
scalar_reduce_product(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_ConstI<IA_Point<int>, int> *lhs =
	(IA_ConstI<IA_Point<int>, int> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval * lhs->value;

    return rval;
}
#endif // scalar_reduce_int_int_product

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_int_product
#define iter_reduce_int_int_product
static int
iter_reduce_product(IA_BaseImage<IA_Point<int>, int> &lhs)
{
    const unsigned sz = lhs.domain().card();

    int ltmp;
    IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval * ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_int_product

#ifndef FILL_REDUCE_int_int_product
#define FILL_REDUCE_int_int_product
void IA_fill_Image_IP_int_int_product_tbl()
{
    if (IA_Image_IP_int_int_product_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_reduce_product;

    IA_Image_IP_int_int_product_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >(iter_reduce_product);
    IA_Image_IP_int_int_product_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_reduce_product);
    IA_Image_IP_int_int_product_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_reduce_product);

}
#endif // REDUCE_int_int_product

#if 0

static int vec_reduce_product(const IA_VectorI<IA_Point<int>, int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) *  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_product
#define const_reduce_int_int_product
static int const_reduce_product(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) * arg);
    }
    return rval;
}
#endif

static int iter_reduce_product(const IA_Image<IA_Point<int>, int> &arg)
{
    IA_IVIter<IA_Point<int>, int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) *  temp);
    }

    return rval;
}

int product ( const IA_Image<IA_Point<int>, int> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 1 );
    IA_Image<IA_Point<int>, int>	arg(arg_);

    IA_BaseImage<IA_Point<int>, int>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, int>::s_type()) {
	return vec_reduce_product((IA_VectorI<IA_Point<int>, int> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, int>::s_type()) {
	return const_reduce_product
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, int> *)bip)->value);
    } else {
	return iter_reduce_product(arg);
    }
}

#endif

template <class T>
inline T max(T a, T b)
{
    return (a<b)?b:a;
}
#define const_reduce_int_int_max
inline int const_reduce_max(unsigned, int arg)
{
    return arg;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction max zero=-MAXINT int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_fn_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:04:51  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

#ifndef REDUCE_int_int_max
#define REDUCE_int_int_max
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_max_tbl;

void IA_fill_Image_IP_int_int_max_tbl();
#endif // REDUCE_int_int_max


int max ( const IA_Image<IA_Point<int>, int> &arg)
{
    if (!IA_Image_IP_int_int_max_tbl)
	IA_fill_Image_IP_int_int_max_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_max_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, int>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_int_max
#define vec_reduce_int_int_max
static int
vec_reduce_max(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_VectorI<IA_Point<int>, int> *lhs =
	(IA_VectorI<IA_Point<int>, int> *) &lhs_;

    const int *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}
#endif // vec_reduce_int_int_max

#ifndef scalar_reduce_int_int_max
#define scalar_reduce_int_int_max
static int
scalar_reduce_max(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_ConstI<IA_Point<int>, int> *lhs =
	(IA_ConstI<IA_Point<int>, int> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = max( rval, lhs->value );

    return rval;
}
#endif // scalar_reduce_int_int_max

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_int_max
#define iter_reduce_int_int_max
static int
iter_reduce_max(IA_BaseImage<IA_Point<int>, int> &lhs)
{
    const unsigned sz = lhs.domain().card();

    int ltmp;
    IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;
    

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = max(rval, ltmp);
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_int_max

#ifndef FILL_REDUCE_int_int_max
#define FILL_REDUCE_int_int_max
void IA_fill_Image_IP_int_int_max_tbl()
{
    if (IA_Image_IP_int_int_max_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_reduce_max;

    IA_Image_IP_int_int_max_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >(iter_reduce_max);
    IA_Image_IP_int_int_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_reduce_max);
    IA_Image_IP_int_int_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_reduce_max);

}
#endif // REDUCE_int_int_max

#if 0

static int vec_reduce_max(const IA_VectorI<IA_Point<int>, int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_max
#define const_reduce_int_int_max
static int const_reduce_max(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = max(rval, arg);
    }
    return rval;
}
#endif

static int iter_reduce_max(const IA_Image<IA_Point<int>, int> &arg)
{
    IA_IVIter<IA_Point<int>, int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = max(rval, temp);
    }

    return rval;
}

int max ( const IA_Image<IA_Point<int>, int> &arg_)
{
    if (arg_.domain().card()==0)
	return ( -MAXINT );
    IA_Image<IA_Point<int>, int>	arg(arg_);

    IA_BaseImage<IA_Point<int>, int>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, int>::s_type()) {
	return vec_reduce_max((IA_VectorI<IA_Point<int>, int> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, int>::s_type()) {
	return const_reduce_max
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, int> *)bip)->value);
    } else {
	return iter_reduce_max(arg);
    }
}
#endif

template <class T>
inline T min(T a, T b)
{
    return (a<b)?a:b;
}
#define const_reduce_int_int_min
inline int const_reduce_min(unsigned, int arg)
{
    return arg;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction min zero=MAXINT int I(int)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_fn_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:04:51  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

#ifndef REDUCE_int_int_min
#define REDUCE_int_int_min
IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >
	*IA_Image_IP_int_int_min_tbl;

void IA_fill_Image_IP_int_int_min_tbl();
#endif // REDUCE_int_int_min


int min ( const IA_Image<IA_Point<int>, int> &arg)
{
    if (!IA_Image_IP_int_int_min_tbl)
	IA_fill_Image_IP_int_int_min_tbl();

    int(*f)
	(IA_BaseImage<IA_Point<int>, int> &);
    f = IA_Image_IP_int_int_min_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, int>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_int_int_min
#define vec_reduce_int_int_min
static int
vec_reduce_min(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_VectorI<IA_Point<int>, int> *lhs =
	(IA_VectorI<IA_Point<int>, int> *) &lhs_;

    const int *ls = lhs->vec;

    int	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}
#endif // vec_reduce_int_int_min

#ifndef scalar_reduce_int_int_min
#define scalar_reduce_int_int_min
static int
scalar_reduce_min(IA_BaseImage<IA_Point<int>, int> &lhs_)
{
    const IA_ConstI<IA_Point<int>, int> *lhs =
	(IA_ConstI<IA_Point<int>, int> *) &lhs_;

    int	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = min( rval, lhs->value );

    return rval;
}
#endif // scalar_reduce_int_int_min

// scalar-scalar operation is trivial

#ifndef iter_reduce_int_int_min
#define iter_reduce_int_int_min
static int
iter_reduce_min(IA_BaseImage<IA_Point<int>, int> &lhs)
{
    const unsigned sz = lhs.domain().card();

    int ltmp;
    IA_BaseIVIter<IA_Point<int>, int>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    int	rval=ltmp;
    

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = min(rval, ltmp);
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_int_int_min

#ifndef FILL_REDUCE_int_int_min
#define FILL_REDUCE_int_int_min
void IA_fill_Image_IP_int_int_min_tbl()
{
    if (IA_Image_IP_int_int_min_tbl)
	return;

    IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >::function f;
    f = iter_reduce_min;

    IA_Image_IP_int_int_min_tbl = new IA_UnaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, int> >(iter_reduce_min);
    IA_Image_IP_int_int_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, int>::s_type(),
	 vec_reduce_min);
    IA_Image_IP_int_int_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, int>::s_type(),
	 scalar_reduce_min);

}
#endif // REDUCE_int_int_min

#if 0

static int vec_reduce_min(const IA_VectorI<IA_Point<int>, int> *arg)
{
    const int *ls = arg->vec;

    int	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_int_int_min
#define const_reduce_int_int_min
static int const_reduce_min(unsigned sz, int arg)
{
    int	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = min(rval, arg);
    }
    return rval;
}
#endif

static int iter_reduce_min(const IA_Image<IA_Point<int>, int> &arg)
{
    IA_IVIter<IA_Point<int>, int>	iter(arg);

    int	temp;
    iter(temp);

    int	rval=temp;

    while(iter(temp)) {
	rval = min(rval, temp);
    }

    return rval;
}

int min ( const IA_Image<IA_Point<int>, int> &arg_)
{
    if (arg_.domain().card()==0)
	return ( MAXINT );
    IA_Image<IA_Point<int>, int>	arg(arg_);

    IA_BaseImage<IA_Point<int>, int>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,int,int,int>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, int>::s_type()) {
	return vec_reduce_min((IA_VectorI<IA_Point<int>, int> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, int>::s_type()) {
	return const_reduce_min
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, int> *)bip)->value);
    } else {
	return iter_reduce_min(arg);
    }
}
#endif

